/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobACL;
import org.apache.hadoop.mapreduce.v2.api.records.AMInfo;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.webapp.AMWebServices;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobCounterInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobTaskAttemptCounterInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.JobTaskCounterInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.ReduceTaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskAttemptsInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TaskInfo;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.TasksInfo;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.AMAttemptInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.AMAttemptsInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.HistoryInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobInfo;
import org.apache.hadoop.mapreduce.v2.hs.webapp.dao.JobsInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.inject.Inject;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.shaded.javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.shaded.javax.ws.rs.GET;
import org.apache.hadoop.shaded.javax.ws.rs.Path;
import org.apache.hadoop.shaded.javax.ws.rs.PathParam;
import org.apache.hadoop.shaded.javax.ws.rs.Produces;
import org.apache.hadoop.shaded.javax.ws.rs.QueryParam;
import org.apache.hadoop.shaded.javax.ws.rs.WebApplicationException;
import org.apache.hadoop.shaded.javax.ws.rs.core.Context;
import org.apache.hadoop.shaded.javax.ws.rs.core.Response;
import org.apache.hadoop.shaded.javax.ws.rs.core.UriInfo;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.apache.hadoop.yarn.webapp.WebApp;

@Path(value="/ws/v1/history")
public class HsWebServices {
    private final HistoryContext ctx;
    private WebApp webapp;
    @Context
    private HttpServletResponse response;
    @Context
    UriInfo uriInfo;

    @Inject
    public HsWebServices(HistoryContext ctx, Configuration conf, WebApp webapp) {
        this.ctx = ctx;
        this.webapp = webapp;
    }

    private boolean hasAccess(Job job, HttpServletRequest request) {
        String remoteUser = request.getRemoteUser();
        if (remoteUser != null) {
            return job.checkAccess(UserGroupInformation.createRemoteUser((String)remoteUser), JobACL.VIEW_JOB);
        }
        return true;
    }

    private void checkAccess(Job job, HttpServletRequest request) {
        if (!this.hasAccess(job, request)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    private void init() {
        this.response.setContentType(null);
    }

    @VisibleForTesting
    void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    @GET
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public HistoryInfo get() {
        return this.getHistoryInfo();
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public HistoryInfo getHistoryInfo() {
        this.init();
        return new HistoryInfo();
    }

    @GET
    @Path(value="/mapreduce/jobs")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public JobsInfo getJobs(@QueryParam(value="user") String userQuery, @QueryParam(value="limit") String count, @QueryParam(value="state") String stateQuery, @QueryParam(value="queue") String queueQuery, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd) {
        Long countParam = null;
        this.init();
        if (count != null && !count.isEmpty()) {
            try {
                countParam = Long.parseLong(count);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException(e.getMessage());
            }
            if (countParam <= 0L) {
                throw new BadRequestException("limit value must be greater then 0");
            }
        }
        Long sBegin = null;
        if (startedBegin != null && !startedBegin.isEmpty()) {
            try {
                sBegin = Long.parseLong(startedBegin);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Invalid number format: " + e.getMessage());
            }
            if (sBegin < 0L) {
                throw new BadRequestException("startedTimeBegin must be greater than 0");
            }
        }
        Long sEnd = null;
        if (startedEnd != null && !startedEnd.isEmpty()) {
            try {
                sEnd = Long.parseLong(startedEnd);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Invalid number format: " + e.getMessage());
            }
            if (sEnd < 0L) {
                throw new BadRequestException("startedTimeEnd must be greater than 0");
            }
        }
        if (sBegin != null && sEnd != null && sBegin > sEnd) {
            throw new BadRequestException("startedTimeEnd must be greater than startTimeBegin");
        }
        Long fBegin = null;
        if (finishBegin != null && !finishBegin.isEmpty()) {
            try {
                fBegin = Long.parseLong(finishBegin);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Invalid number format: " + e.getMessage());
            }
            if (fBegin < 0L) {
                throw new BadRequestException("finishedTimeBegin must be greater than 0");
            }
        }
        Long fEnd = null;
        if (finishEnd != null && !finishEnd.isEmpty()) {
            try {
                fEnd = Long.parseLong(finishEnd);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Invalid number format: " + e.getMessage());
            }
            if (fEnd < 0L) {
                throw new BadRequestException("finishedTimeEnd must be greater than 0");
            }
        }
        if (fBegin != null && fEnd != null && fBegin > fEnd) {
            throw new BadRequestException("finishedTimeEnd must be greater than finishedTimeBegin");
        }
        JobState jobState = null;
        if (stateQuery != null) {
            jobState = JobState.valueOf((String)stateQuery);
        }
        return this.ctx.getPartialJobs(0L, countParam, userQuery, queueQuery, sBegin, sEnd, fBegin, fEnd, jobState);
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public JobInfo getJob(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.ctx);
        this.checkAccess(job, hsr);
        return new JobInfo(job);
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/jobattempts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AMAttemptsInfo getJobAttempts(@PathParam(value="jobid") String jid) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.ctx);
        AMAttemptsInfo amAttempts = new AMAttemptsInfo();
        for (AMInfo amInfo : job.getAMInfos()) {
            AMAttemptInfo attempt = new AMAttemptInfo(amInfo, MRApps.toString((JobId)job.getID()), job.getUserName(), this.uriInfo.getBaseUri().toString(), this.webapp.name());
            amAttempts.add(attempt);
        }
        return amAttempts;
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/counters")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public JobCounterInfo getJobCounters(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.ctx);
        this.checkAccess(job, hsr);
        return new JobCounterInfo((AppContext)this.ctx, job);
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/conf")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ConfInfo getJobConf(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid) {
        ConfInfo info;
        this.init();
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.ctx);
        this.checkAccess(job, hsr);
        try {
            info = new ConfInfo(job);
        }
        catch (IOException e) {
            throw new NotFoundException("unable to load configuration for job: " + jid);
        }
        return info;
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TasksInfo getJobTasks(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @QueryParam(value="type") String type) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.ctx);
        this.checkAccess(job, hsr);
        TasksInfo allTasks = new TasksInfo();
        for (Task task : job.getTasks().values()) {
            TaskType ttype = null;
            if (type != null && !type.isEmpty()) {
                try {
                    ttype = MRApps.taskType((String)type);
                }
                catch (YarnRuntimeException e) {
                    throw new BadRequestException("tasktype must be either m or r");
                }
            }
            if (ttype != null && task.getType() != ttype) continue;
            allTasks.add(new TaskInfo(task));
        }
        return allTasks;
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks/{taskid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TaskInfo getJobTask(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.ctx);
        this.checkAccess(job, hsr);
        Task task = AMWebServices.getTaskFromTaskIdString((String)tid, (Job)job);
        return new TaskInfo(task);
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks/{taskid}/counters")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public JobTaskCounterInfo getSingleTaskCounters(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.ctx);
        this.checkAccess(job, hsr);
        TaskId taskID = MRApps.toTaskID((String)tid);
        if (taskID == null) {
            throw new NotFoundException("taskid " + tid + " not found or invalid");
        }
        Task task = job.getTask(taskID);
        if (task == null) {
            throw new NotFoundException("task not found with id " + tid);
        }
        return new JobTaskCounterInfo(task);
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks/{taskid}/attempts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TaskAttemptsInfo getJobTaskAttempts(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid) {
        this.init();
        TaskAttemptsInfo attempts = new TaskAttemptsInfo();
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.ctx);
        this.checkAccess(job, hsr);
        Task task = AMWebServices.getTaskFromTaskIdString((String)tid, (Job)job);
        for (TaskAttempt ta : task.getAttempts().values()) {
            if (ta == null) continue;
            if (task.getType() == TaskType.REDUCE) {
                attempts.add((TaskAttemptInfo)new ReduceTaskAttemptInfo(ta, task.getType()));
                continue;
            }
            attempts.add(new TaskAttemptInfo(ta, task.getType(), Boolean.valueOf(false)));
        }
        return attempts;
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks/{taskid}/attempts/{attemptid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TaskAttemptInfo getJobTaskAttemptId(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid, @PathParam(value="attemptid") String attId) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.ctx);
        this.checkAccess(job, hsr);
        Task task = AMWebServices.getTaskFromTaskIdString((String)tid, (Job)job);
        TaskAttempt ta = AMWebServices.getTaskAttemptFromTaskAttemptString((String)attId, (Task)task);
        if (task.getType() == TaskType.REDUCE) {
            return new ReduceTaskAttemptInfo(ta, task.getType());
        }
        return new TaskAttemptInfo(ta, task.getType(), Boolean.valueOf(false));
    }

    @GET
    @Path(value="/mapreduce/jobs/{jobid}/tasks/{taskid}/attempts/{attemptid}/counters")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public JobTaskAttemptCounterInfo getJobTaskAttemptIdCounters(@Context HttpServletRequest hsr, @PathParam(value="jobid") String jid, @PathParam(value="taskid") String tid, @PathParam(value="attemptid") String attId) {
        this.init();
        Job job = AMWebServices.getJobFromJobIdString((String)jid, (AppContext)this.ctx);
        this.checkAccess(job, hsr);
        Task task = AMWebServices.getTaskFromTaskIdString((String)tid, (Job)job);
        TaskAttempt ta = AMWebServices.getTaskAttemptFromTaskAttemptString((String)attId, (Task)task);
        return new JobTaskAttemptCounterInfo(ta);
    }
}

