/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.org.apache.commons.cli.CommandLine;
import org.apache.hadoop.shaded.org.apache.commons.cli.Options;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Private
public class DelegationTokenFetcher {
    private static final String WEBSERVICE = "webservice";
    private static final String CANCEL = "cancel";
    private static final String HELP = "help";
    private static final String HELP_SHORT = "h";
    private static final Log LOG = LogFactory.getLog(DelegationTokenFetcher.class);
    private static final String PRINT = "print";
    private static final String RENEW = "renew";
    private static final String RENEWER = "renewer";
    private static final String VERBOSE = "verbose";

    public static void main(String[] args) throws Exception {
        int commandCount;
        HdfsConfiguration conf = new HdfsConfiguration();
        Options fetcherOptions = new Options();
        fetcherOptions.addOption(WEBSERVICE, true, "HTTP url to reach the NameNode at").addOption(RENEWER, true, "Name of the delegation token renewer").addOption(CANCEL, false, "cancel the token").addOption(RENEW, false, "renew the token").addOption(PRINT, false, "print the token").addOption(VERBOSE, false, "print verbose output").addOption(HELP_SHORT, HELP, false, "print out help information");
        GenericOptionsParser parser = new GenericOptionsParser((Configuration)conf, fetcherOptions, args);
        CommandLine cmd = parser.getCommandLine();
        String webUrl = cmd.hasOption(WEBSERVICE) ? cmd.getOptionValue(WEBSERVICE) : null;
        String renewer = cmd.hasOption(RENEWER) ? cmd.getOptionValue(RENEWER) : null;
        boolean cancel = cmd.hasOption(CANCEL);
        boolean renew = cmd.hasOption(RENEW);
        final boolean print = cmd.hasOption(PRINT);
        boolean verbose = cmd.hasOption(VERBOSE);
        boolean help = cmd.hasOption(HELP);
        String[] remaining = parser.getRemainingArgs();
        if (help) {
            DelegationTokenFetcher.printUsage(System.out);
            System.exit(0);
        }
        if ((commandCount = (cancel ? 1 : 0) + (renew ? 1 : 0) + (print ? 1 : 0)) > 1) {
            System.err.println("ERROR: Only specify cancel, renew or print.");
            DelegationTokenFetcher.printUsage(System.err);
        }
        if (remaining.length != 1 || remaining[0].charAt(0) == '-') {
            System.err.println("ERROR: Must specify exactly one token file");
            DelegationTokenFetcher.printUsage(System.err);
        }
        LocalFileSystem local = FileSystem.getLocal((Configuration)conf);
        Path tokenFile = new Path(local.getWorkingDirectory(), remaining[0]);
        UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Configuration)conf, tokenFile, verbose, cancel, renew, webUrl, renewer){
            final /* synthetic */ Configuration val$conf;
            final /* synthetic */ Path val$tokenFile;
            final /* synthetic */ boolean val$verbose;
            final /* synthetic */ boolean val$cancel;
            final /* synthetic */ boolean val$renew;
            final /* synthetic */ String val$webUrl;
            final /* synthetic */ String val$renewer;
            {
                this.val$conf = configuration;
                this.val$tokenFile = path;
                this.val$verbose = bl2;
                this.val$cancel = bl3;
                this.val$renew = bl4;
                this.val$webUrl = string;
                this.val$renewer = string2;
            }

            @Override
            public Object run() throws Exception {
                if (print) {
                    DelegationTokenFetcher.printTokens(this.val$conf, this.val$tokenFile, this.val$verbose);
                } else if (this.val$cancel) {
                    DelegationTokenFetcher.cancelTokens(this.val$conf, this.val$tokenFile);
                } else if (this.val$renew) {
                    DelegationTokenFetcher.renewTokens(this.val$conf, this.val$tokenFile);
                } else {
                    FileSystem fs = DelegationTokenFetcher.getFileSystem(this.val$conf, this.val$webUrl);
                    DelegationTokenFetcher.saveDelegationToken(this.val$conf, fs, this.val$renewer, this.val$tokenFile);
                }
                return null;
            }
        });
    }

    private static FileSystem getFileSystem(Configuration conf, String url) throws IOException {
        if (url == null) {
            return FileSystem.get((Configuration)conf);
        }
        URI fsUri = URI.create(url.replaceFirst("^http://", "webhdfs://").replaceFirst("^https://", "swebhdfs://"));
        return FileSystem.get((URI)fsUri, (Configuration)conf);
    }

    @VisibleForTesting
    static void cancelTokens(Configuration conf, Path tokenFile) throws IOException, InterruptedException {
        for (Token<?> token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
            if (!token.isManaged()) continue;
            token.cancel(conf);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Cancelled token for " + token.getService()));
        }
    }

    @VisibleForTesting
    static void renewTokens(Configuration conf, Path tokenFile) throws IOException, InterruptedException {
        for (Token<?> token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
            if (!token.isManaged()) continue;
            long result = token.renew(conf);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Renewed token for " + token.getService() + " until: " + new Date(result)));
        }
    }

    @VisibleForTesting
    static void saveDelegationToken(Configuration conf, FileSystem fs, String renewer, Path tokenFile) throws IOException {
        Token token = fs.getDelegationToken(renewer);
        if (null != token) {
            Credentials cred = new Credentials();
            cred.addToken(token.getService(), token);
            cred.writeTokenStorageFile(tokenFile, conf, Credentials.SerializedFormat.WRITABLE);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Fetched token " + fs.getUri() + " for " + token.getService() + " into " + tokenFile));
            }
        } else {
            System.err.println("ERROR: Failed to fetch token from " + fs.getUri());
        }
    }

    @VisibleForTesting
    static String printTokensToString(Configuration conf, Path tokenFile, boolean verbose) throws IOException {
        StringBuilder sbld = new StringBuilder();
        String nl = System.getProperty("line.separator");
        DelegationTokenIdentifier id = new DelegationTokenSecretManager(0L, 0L, 0L, 0L, null).createIdentifier();
        for (Token<?> token : DelegationTokenFetcher.readTokens(tokenFile, conf)) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));
            id.readFields((DataInput)in);
            String idStr = verbose ? id.toString() : id.toStringStable();
            sbld.append("Token (").append(idStr).append(") for ").append(token.getService()).append(nl);
        }
        return sbld.toString();
    }

    static void printTokens(Configuration conf, Path tokenFile, boolean verbose) throws IOException {
        System.out.print(DelegationTokenFetcher.printTokensToString(conf, tokenFile, verbose));
    }

    private static void printUsage(PrintStream err) {
        err.println("fetchdt retrieves delegation tokens from the NameNode");
        err.println();
        err.println("fetchdt <opts> <token file>");
        err.println("Options:");
        err.println("  --webservice <url>  Url to contact NN on (starts with http:// or https://)");
        err.println("  --renewer <name>    Name of the delegation token renewer");
        err.println("  --cancel            Cancel the delegation token");
        err.println("  --renew             Renew the delegation token.  Delegation token must have been fetched using the --renewer <name> option.");
        err.println("  --print [--verbose] Print the delegation token, when --verbose is passed, print more information about the token");
        err.println();
        GenericOptionsParser.printGenericCommandUsage((PrintStream)err);
        ExitUtil.terminate((int)1);
    }

    private static Collection<Token<?>> readTokens(Path file, Configuration conf) throws IOException {
        Credentials creds = Credentials.readTokenStorageFile((Path)file, (Configuration)conf);
        return creds.getAllTokens();
    }
}

