/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.loadGenerator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.loadGenerator.LoadGenerator;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadGeneratorMR
extends LoadGenerator {
    public static final Logger LOG = LoggerFactory.getLogger(LoadGenerator.class);
    private static int numMapTasks = 1;
    private String mrOutDir;
    private static final String USAGE_CMD = "java LoadGeneratorMR\n";
    private static final String USAGE = "java LoadGeneratorMR\n-mr <numMapJobs> <outputDir> [MUST be first 3 args] \n-readProbability <read probability>\n-writeProbability <write probability>\n-root <root>\n-maxDelayBetweenOps <maxDelayBetweenOpsInMillis>\n-numOfThreads <numOfThreads>\n-elapsedTime <elapsedTimeInSecs>\n-startTime <startTimeInMillis>\n-scriptFile <filename>\n-flagFile <filename>";
    private static final Text OPEN_EXECTIME = new Text("OpenExecutionTime");
    private static final Text NUMOPS_OPEN = new Text("NumOpsOpen");
    private static final Text LIST_EXECTIME = new Text("ListExecutionTime");
    private static final Text NUMOPS_LIST = new Text("NumOpsList");
    private static final Text DELETE_EXECTIME = new Text("DeletionExecutionTime");
    private static final Text NUMOPS_DELETE = new Text("NumOpsDelete");
    private static final Text CREATE_EXECTIME = new Text("CreateExecutionTime");
    private static final Text NUMOPS_CREATE = new Text("NumOpsCreate");
    private static final Text WRITE_CLOSE_EXECTIME = new Text("WriteCloseExecutionTime");
    private static final Text NUMOPS_WRITE_CLOSE = new Text("NumOpsWriteClose");
    private static final Text ELAPSED_TIME = new Text("ElapsedTime");
    private static final Text TOTALOPS = new Text("TotalOps");
    private static final String LG_ROOT = "LG.root";
    private static final String LG_SCRIPTFILE = "LG.scriptFile";
    private static final String LG_MAXDELAYBETWEENOPS = "LG.maxDelayBetweenOps";
    private static final String LG_NUMOFTHREADS = "LG.numOfThreads";
    private static final String LG_READPR = "LG.readPr";
    private static final String LG_WRITEPR = "LG.writePr";
    private static final String LG_SEED = "LG.r";
    private static final String LG_NUMMAPTASKS = "LG.numMapTasks";
    private static final String LG_ELAPSEDTIME = "LG.elapsedTime";
    private static final String LG_STARTTIME = "LG.startTime";
    private static final String LG_FLAGFILE = "LG.flagFile";

    public LoadGeneratorMR() throws IOException, UnknownHostException {
    }

    public LoadGeneratorMR(Configuration conf) throws IOException, UnknownHostException {
        this();
        this.setConf(conf);
    }

    @Override
    public int run(String[] args) throws Exception {
        int exitCode = this.parseArgsMR(args);
        if (exitCode != 0) {
            return exitCode;
        }
        System.out.println("Running LoadGeneratorMR against fileSystem: " + FileContext.getFileContext().getDefaultFileSystem().getUri());
        return this.submitAsMapReduce();
    }

    private int parseArgsMR(String[] args) throws IOException {
        try {
            if (args.length >= 3 && args[0].equals("-mr")) {
                numMapTasks = Integer.parseInt(args[1]);
                this.mrOutDir = args[2];
                if (this.mrOutDir.startsWith("-")) {
                    System.err.println("Missing output file parameter, instead got: " + this.mrOutDir);
                    System.err.println(USAGE);
                    return -1;
                }
            } else {
                System.err.println(USAGE);
                ToolRunner.printGenericCommandUsage((PrintStream)System.err);
                return -1;
            }
            String[] strippedArgs = new String[args.length - 3];
            for (int i = 0; i < strippedArgs.length; ++i) {
                strippedArgs[i] = args[i + 3];
            }
            super.parseArgs(true, strippedArgs);
        }
        catch (NumberFormatException e) {
            System.err.println("Illegal parameter: " + e.getLocalizedMessage());
            System.err.println(USAGE);
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new LoadGeneratorMR(), (String[])args);
        System.exit(res);
    }

    private int submitAsMapReduce() {
        System.out.println("Running as a MapReduce job with " + numMapTasks + " mapTasks;  Output to file " + this.mrOutDir);
        Configuration conf = new Configuration(this.getConf());
        conf.set(LG_ROOT, root.toString());
        conf.setInt(LG_MAXDELAYBETWEENOPS, maxDelayBetweenOps);
        conf.setInt(LG_NUMOFTHREADS, numOfThreads);
        conf.set(LG_READPR, readProbs[0] + "");
        conf.set(LG_WRITEPR, writeProbs[0] + "");
        conf.setLong(LG_SEED, seed);
        conf.setInt(LG_NUMMAPTASKS, numMapTasks);
        if (scriptFile == null && durations[0] <= 0L) {
            System.err.println("When run as a MapReduce job, elapsed Time or ScriptFile must be specified");
            System.exit(-1);
        }
        conf.setLong(LG_ELAPSEDTIME, durations[0]);
        conf.setLong(LG_STARTTIME, startTime);
        if (scriptFile != null) {
            conf.set(LG_SCRIPTFILE, scriptFile);
        }
        conf.set(LG_FLAGFILE, flagFile.toString());
        JobConf jobConf = new JobConf(conf, LoadGenerator.class);
        jobConf.setJobName("NNLoadGeneratorViaMR");
        jobConf.setNumMapTasks(numMapTasks);
        jobConf.setNumReduceTasks(1);
        jobConf.setOutputKeyClass(Text.class);
        jobConf.setOutputValueClass(IntWritable.class);
        jobConf.setMapperClass(MapperThatRunsNNLoadGenerator.class);
        jobConf.setReducerClass(ReducerThatCollectsLGdata.class);
        jobConf.setInputFormat(DummyInputFormat.class);
        jobConf.setOutputFormat(TextOutputFormat.class);
        jobConf.setMaxMapAttempts(1);
        jobConf.setSpeculativeExecution(false);
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)new Path(this.mrOutDir));
        try {
            JobClient.runJob((JobConf)jobConf);
        }
        catch (IOException e) {
            System.err.println("Failed to run job: " + e.getMessage());
            return -1;
        }
        return 0;
    }

    public static class ReducerThatCollectsLGdata
    extends MapReduceBase
    implements Reducer<Text, IntWritable, Text, IntWritable> {
        private IntWritable result = new IntWritable();
        private JobConf jobConf;

        public void configure(JobConf job) {
            this.jobConf = job;
        }

        public void reduce(Text key, Iterator<IntWritable> values, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            int sum = 0;
            while (values.hasNext()) {
                sum += values.next().get();
            }
            if (key.equals((Object)OPEN_EXECTIME)) {
                LoadGenerator.executionTime[0] = sum;
            } else if (key.equals((Object)NUMOPS_OPEN)) {
                LoadGenerator.numOfOps[0] = sum;
            } else if (key.equals((Object)LIST_EXECTIME)) {
                LoadGenerator.executionTime[1] = sum;
            } else if (key.equals((Object)NUMOPS_LIST)) {
                LoadGenerator.numOfOps[1] = sum;
            } else if (key.equals((Object)DELETE_EXECTIME)) {
                LoadGenerator.executionTime[4] = sum;
            } else if (key.equals((Object)NUMOPS_DELETE)) {
                LoadGenerator.numOfOps[4] = sum;
            } else if (key.equals((Object)CREATE_EXECTIME)) {
                LoadGenerator.executionTime[2] = sum;
            } else if (key.equals((Object)NUMOPS_CREATE)) {
                LoadGenerator.numOfOps[2] = sum;
            } else if (key.equals((Object)WRITE_CLOSE_EXECTIME)) {
                System.out.println(WRITE_CLOSE_EXECTIME + " = " + sum);
                LoadGenerator.executionTime[3] = sum;
            } else if (key.equals((Object)NUMOPS_WRITE_CLOSE)) {
                LoadGenerator.numOfOps[3] = sum;
            } else if (key.equals((Object)TOTALOPS)) {
                LoadGenerator.totalOps = sum;
            } else if (key.equals((Object)ELAPSED_TIME)) {
                LoadGenerator.totalTime = sum;
            }
            this.result.set(sum);
            output.collect((Object)key, (Object)this.result);
        }

        public void close() throws IOException {
            FileContext fc;
            try {
                fc = FileContext.getFileContext((Configuration)this.jobConf);
            }
            catch (IOException ioe) {
                System.err.println("Can not initialize the file system: " + ioe.getLocalizedMessage());
                return;
            }
            FSDataOutputStream o = fc.create(FileOutputFormat.getTaskOutputPath((JobConf)this.jobConf, (String)"Results"), EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]);
            PrintStream out = new PrintStream((OutputStream)o);
            LoadGenerator.printResults(out);
            out.close();
            o.close();
        }
    }

    public static class MapperThatRunsNNLoadGenerator
    extends MapReduceBase
    implements Mapper<LongWritable, Text, Text, IntWritable> {
        private JobConf jobConf;

        public void configure(JobConf job) {
            this.jobConf = job;
            this.getArgsFromConfiguration((Configuration)this.jobConf);
        }

        public void map(LongWritable key, Text value, OutputCollector<Text, IntWritable> output, Reporter reporter) throws IOException {
            ProgressThread progressThread = new ProgressThread(reporter);
            progressThread.start();
            try {
                new LoadGenerator((Configuration)this.jobConf).generateLoadOnNN();
                System.out.println("Finished generating load on NN, sending results to the reducer");
                LoadGenerator.printResults(System.out);
                progressThread.keepGoing = false;
                progressThread.join();
                output.collect((Object)OPEN_EXECTIME, (Object)new IntWritable((int)LoadGenerator.executionTime[0]));
                output.collect((Object)NUMOPS_OPEN, (Object)new IntWritable((int)LoadGenerator.numOfOps[0]));
                output.collect((Object)LIST_EXECTIME, (Object)new IntWritable((int)LoadGenerator.executionTime[1]));
                output.collect((Object)NUMOPS_LIST, (Object)new IntWritable((int)LoadGenerator.numOfOps[1]));
                output.collect((Object)DELETE_EXECTIME, (Object)new IntWritable((int)LoadGenerator.executionTime[4]));
                output.collect((Object)NUMOPS_DELETE, (Object)new IntWritable((int)LoadGenerator.numOfOps[4]));
                output.collect((Object)CREATE_EXECTIME, (Object)new IntWritable((int)LoadGenerator.executionTime[2]));
                output.collect((Object)NUMOPS_CREATE, (Object)new IntWritable((int)LoadGenerator.numOfOps[2]));
                output.collect((Object)WRITE_CLOSE_EXECTIME, (Object)new IntWritable((int)LoadGenerator.executionTime[3]));
                output.collect((Object)NUMOPS_WRITE_CLOSE, (Object)new IntWritable((int)LoadGenerator.numOfOps[3]));
                output.collect((Object)TOTALOPS, (Object)new IntWritable((int)LoadGenerator.totalOps));
                output.collect((Object)ELAPSED_TIME, (Object)new IntWritable((int)LoadGenerator.totalTime));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void getArgsFromConfiguration(Configuration conf) {
            LoadGenerator.maxDelayBetweenOps = conf.getInt(LoadGeneratorMR.LG_MAXDELAYBETWEENOPS, LoadGenerator.maxDelayBetweenOps);
            LoadGenerator.numOfThreads = conf.getInt(LoadGeneratorMR.LG_NUMOFTHREADS, LoadGenerator.numOfThreads);
            LoadGenerator.readProbs[0] = Double.parseDouble(conf.get(LoadGeneratorMR.LG_READPR, LoadGenerator.readProbs[0] + ""));
            LoadGenerator.writeProbs[0] = Double.parseDouble(conf.get(LoadGeneratorMR.LG_WRITEPR, LoadGenerator.writeProbs[0] + ""));
            LoadGenerator.seed = conf.getLong(LoadGeneratorMR.LG_SEED, LoadGenerator.seed);
            numMapTasks = conf.getInt(LoadGeneratorMR.LG_NUMMAPTASKS, numMapTasks);
            LoadGenerator.root = new Path(conf.get(LoadGeneratorMR.LG_ROOT, LoadGenerator.root.toString()));
            LoadGenerator.durations[0] = conf.getLong(LoadGeneratorMR.LG_ELAPSEDTIME, 0L);
            LoadGenerator.startTime = conf.getLong(LoadGeneratorMR.LG_STARTTIME, 0L);
            LoadGenerator.scriptFile = conf.get(LoadGeneratorMR.LG_SCRIPTFILE, null);
            LoadGenerator.flagFile = new Path(conf.get(LoadGeneratorMR.LG_FLAGFILE, "/tmp/flagFile"));
            if (LoadGenerator.durations[0] > 0L && LoadGenerator.scriptFile != null) {
                System.err.println("Cannot specify both ElapsedTime and ScriptFile, exiting");
                System.exit(-1);
            }
            try {
                if (LoadGenerator.scriptFile != null && LoadGenerator.loadScriptFile(LoadGenerator.scriptFile, false) < 0) {
                    System.err.println("Error in scriptFile, exiting");
                    System.exit(-1);
                }
            }
            catch (IOException e) {
                System.err.println("Error loading script file " + LoadGenerator.scriptFile);
                e.printStackTrace();
            }
            if (LoadGenerator.durations[0] <= 0L) {
                System.err.println("A duration of zero or less is not allowed when running via MapReduce.");
                System.exit(-1);
            }
        }

        private class ProgressThread
        extends Thread {
            boolean keepGoing;
            private Reporter reporter;

            public ProgressThread(Reporter r) {
                this.reporter = r;
                this.keepGoing = true;
            }

            @Override
            public void run() {
                while (this.keepGoing) {
                    if (!ProgressThread.interrupted()) {
                        try {
                            ProgressThread.sleep(30000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.reporter.progress();
                }
            }
        }
    }

    public static class DummyInputFormat
    extends Configured
    implements InputFormat<LongWritable, Text> {
        public InputSplit[] getSplits(JobConf conf, int numSplits) {
            numSplits = conf.getInt(LoadGeneratorMR.LG_NUMMAPTASKS, 1);
            InputSplit[] ret = new InputSplit[numSplits];
            for (int i = 0; i < numSplits; ++i) {
                ret[i] = new EmptySplit();
            }
            return ret;
        }

        public RecordReader<LongWritable, Text> getRecordReader(InputSplit ignored, JobConf conf, Reporter reporter) throws IOException {
            return new RecordReader<LongWritable, Text>(){
                boolean sentOneRecord = false;

                public boolean next(LongWritable key, Text value) throws IOException {
                    key.set(1L);
                    value.set("dummy");
                    if (!this.sentOneRecord) {
                        this.sentOneRecord = true;
                        return true;
                    }
                    return false;
                }

                public LongWritable createKey() {
                    return new LongWritable();
                }

                public Text createValue() {
                    return new Text();
                }

                public long getPos() throws IOException {
                    return 1L;
                }

                public void close() throws IOException {
                }

                public float getProgress() throws IOException {
                    return 1.0f;
                }
            };
        }
    }

    public static class EmptySplit
    implements InputSplit {
        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }

        public long getLength() {
            return 0L;
        }

        public String[] getLocations() {
            return new String[0];
        }
    }
}

