/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.clients.log4jappender;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientConfigurationConstants;
import org.apache.flume.api.RpcClientFactory;
import org.apache.flume.clients.log4jappender.Log4jAvroHeaders;
import org.apache.flume.event.EventBuilder;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class Log4jAppender
extends AppenderSkeleton {
    private String hostname;
    private int port;
    private boolean unsafeMode = false;
    private long timeout = RpcClientConfigurationConstants.DEFAULT_REQUEST_TIMEOUT_MILLIS;
    private boolean avroReflectionEnabled;
    private String avroSchemaUrl;
    RpcClient rpcClient = null;
    private Schema schema;
    private ByteArrayOutputStream out;
    private DatumWriter<Object> writer;
    private BinaryEncoder encoder;

    public Log4jAppender() {
    }

    public Log4jAppender(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    @Override
    public synchronized void append(LoggingEvent event) throws FlumeException {
        Event flumeEvent;
        if (this.rpcClient == null) {
            String errorMsg = "Cannot Append to Appender! Appender either closed or not setup correctly!";
            LogLog.error(errorMsg);
            if (this.unsafeMode) {
                return;
            }
            throw new FlumeException(errorMsg);
        }
        if (!this.rpcClient.isActive()) {
            this.reconnect();
        }
        HashMap<String, String> hdrs = new HashMap<String, String>();
        hdrs.put(Log4jAvroHeaders.LOGGER_NAME.toString(), event.getLoggerName());
        hdrs.put(Log4jAvroHeaders.TIMESTAMP.toString(), String.valueOf(event.timeStamp));
        hdrs.put(Log4jAvroHeaders.LOG_LEVEL.toString(), String.valueOf(event.getLevel().toInt()));
        Object message = event.getMessage();
        if (message instanceof GenericRecord) {
            GenericRecord record = (GenericRecord)message;
            this.populateAvroHeaders(hdrs, record.getSchema(), message);
            flumeEvent = EventBuilder.withBody(this.serialize(record, record.getSchema()), hdrs);
        } else if (message instanceof SpecificRecord || this.avroReflectionEnabled) {
            Schema schema = ReflectData.get().getSchema(message.getClass());
            this.populateAvroHeaders(hdrs, schema, message);
            flumeEvent = EventBuilder.withBody(this.serialize(message, schema), hdrs);
        } else {
            hdrs.put(Log4jAvroHeaders.MESSAGE_ENCODING.toString(), "UTF8");
            String msg = this.layout != null ? this.layout.format(event) : message.toString();
            flumeEvent = EventBuilder.withBody(msg, Charset.forName("UTF8"), hdrs);
        }
        try {
            this.rpcClient.append(flumeEvent);
        }
        catch (EventDeliveryException e) {
            String msg = "Flume append() failed.";
            LogLog.error(msg);
            if (this.unsafeMode) {
                return;
            }
            throw new FlumeException(msg + " Exception follows.", e);
        }
    }

    protected void populateAvroHeaders(Map<String, String> hdrs, Schema schema, Object message) {
        if (this.avroSchemaUrl != null) {
            hdrs.put(Log4jAvroHeaders.AVRO_SCHEMA_URL.toString(), this.avroSchemaUrl);
            return;
        }
        LogLog.warn("Cannot find ID for schema. Adding header for schema, which may be inefficient. Consider setting up an Avro Schema Cache.");
        hdrs.put(Log4jAvroHeaders.AVRO_SCHEMA_LITERAL.toString(), schema.toString());
    }

    private byte[] serialize(Object datum, Schema datumSchema) throws FlumeException {
        if (this.schema == null || !datumSchema.equals(this.schema)) {
            this.schema = datumSchema;
            this.out = new ByteArrayOutputStream();
            this.writer = new ReflectDatumWriter<Object>(this.schema);
            this.encoder = EncoderFactory.get().binaryEncoder(this.out, null);
        }
        this.out.reset();
        try {
            this.writer.write(datum, this.encoder);
            this.encoder.flush();
            return this.out.toByteArray();
        }
        catch (IOException e) {
            throw new FlumeException(e);
        }
    }

    @Override
    public synchronized void close() throws FlumeException {
        if (this.rpcClient != null) {
            try {
                this.rpcClient.close();
            }
            catch (FlumeException ex) {
                LogLog.error("Error while trying to close RpcClient.", ex);
                if (this.unsafeMode) {
                    return;
                }
                throw ex;
            }
            finally {
                this.rpcClient = null;
            }
        } else {
            String errorMsg = "Flume log4jappender already closed!";
            LogLog.error(errorMsg);
            if (this.unsafeMode) {
                return;
            }
            throw new FlumeException(errorMsg);
        }
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUnsafeMode(boolean unsafeMode) {
        this.unsafeMode = unsafeMode;
    }

    public boolean getUnsafeMode() {
        return this.unsafeMode;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setAvroReflectionEnabled(boolean avroReflectionEnabled) {
        this.avroReflectionEnabled = avroReflectionEnabled;
    }

    public void setAvroSchemaUrl(String avroSchemaUrl) {
        this.avroSchemaUrl = avroSchemaUrl;
    }

    @Override
    public void activateOptions() throws FlumeException {
        Properties props = new Properties();
        props.setProperty("hosts", "h1");
        props.setProperty("hosts.h1", this.hostname + ":" + this.port);
        props.setProperty("connect-timeout", String.valueOf(this.timeout));
        props.setProperty("request-timeout", String.valueOf(this.timeout));
        try {
            this.rpcClient = RpcClientFactory.getInstance(props);
            if (this.layout != null) {
                this.layout.activateOptions();
            }
        }
        catch (FlumeException e) {
            String errormsg = "RPC client creation failed! " + e.getMessage();
            LogLog.error(errormsg);
            if (this.unsafeMode) {
                return;
            }
            throw e;
        }
    }

    private void reconnect() throws FlumeException {
        this.close();
        this.activateOptions();
    }
}

