/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router;

import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.DualAbstractHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.Routed;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.router.Router;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutorGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
extends DualAbstractHandler<ChannelInboundHandler, Router> {
    public static final String ROUTER_HANDLER_NAME = Handler.class.getName() + "_ROUTER_HANDLER";
    public static final String ROUTED_HANDLER_NAME = Handler.class.getName() + "_ROUTED_HANDLER";
    protected EventExecutorGroup group;

    public Handler(Router router) {
        super(router);
    }

    public Handler group(EventExecutorGroup eventExecutorGroup) {
        this.group = eventExecutorGroup;
        return this;
    }

    public EventExecutorGroup group() {
        return this.group;
    }

    public String name() {
        return ROUTER_HANDLER_NAME;
    }

    @Override
    protected void routed(ChannelHandlerContext channelHandlerContext, Routed routed) throws Exception {
        ChannelPipeline channelPipeline;
        ChannelHandler channelHandler;
        ChannelInboundHandler channelInboundHandler = (ChannelInboundHandler)routed.instanceFromTarget();
        if (channelInboundHandler != (channelHandler = (channelPipeline = channelHandlerContext.pipeline()).get(ROUTED_HANDLER_NAME))) {
            if (channelHandler == null) {
                if (this.group == null) {
                    channelPipeline.addAfter(ROUTER_HANDLER_NAME, ROUTED_HANDLER_NAME, channelInboundHandler);
                } else {
                    channelPipeline.addAfter(this.group, ROUTER_HANDLER_NAME, ROUTED_HANDLER_NAME, channelInboundHandler);
                }
            } else {
                channelPipeline.replace(channelHandler, ROUTED_HANDLER_NAME, (ChannelHandler)channelInboundHandler);
            }
        }
        routed.retain();
        channelHandlerContext.fireChannelRead(routed);
    }
}

