/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.shell.support.util.IOUtils;
import org.springframework.util.Assert;

public class LoggingOutputStream
extends OutputStream {
    protected static final Logger LOGGER = HandlerUtils.getLogger(LoggingOutputStream.class);
    private final Level level;
    private String sourceClassName = LoggingOutputStream.class.getName();
    private int count;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public LoggingOutputStream(Level level) {
        Assert.notNull(level, "A logging level is required");
        this.level = level;
    }

    @Override
    public void write(int b) throws IOException {
        this.baos.write(b);
        ++this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.count > 0) {
            String msg = new String(this.baos.toByteArray());
            LogRecord record = new LogRecord(this.level, msg);
            record.setSourceClassName(this.sourceClassName);
            try {
                LOGGER.log(record);
                this.count = 0;
            }
            catch (Throwable throwable) {
                this.count = 0;
                IOUtils.closeQuietly(this.baos);
                this.baos = new ByteArrayOutputStream();
                throw throwable;
            }
            IOUtils.closeQuietly(this.baos);
            this.baos = new ByteArrayOutputStream();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }
}

