/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.springframework.util.Assert;

public class DeferredLogHandler
extends Handler {
    private final List<LogRecord> logRecords = Collections.synchronizedList(new ArrayList());
    private final Handler fallbackHandler;
    private final Level fallbackPushLevel;
    private boolean fallbackMode = false;
    private Handler targetHandler;

    public DeferredLogHandler(Handler fallbackHandler, Level fallbackPushLevel) {
        Assert.notNull(fallbackHandler, "Fallback handler required");
        Assert.notNull(fallbackPushLevel, "Fallback push level required");
        this.fallbackHandler = fallbackHandler;
        this.fallbackPushLevel = fallbackPushLevel;
    }

    @Override
    public void close() throws SecurityException {
        if (this.targetHandler == null) {
            this.fallbackMode = true;
        }
        if (this.fallbackMode) {
            this.publishLogRecordsTo(this.fallbackHandler);
            this.fallbackHandler.close();
            return;
        }
        this.targetHandler.close();
    }

    @Override
    public void flush() {
        if (this.targetHandler == null) {
            this.fallbackMode = true;
        }
        if (this.fallbackMode) {
            this.publishLogRecordsTo(this.fallbackHandler);
            this.fallbackHandler.flush();
            return;
        }
        this.targetHandler.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if (this.fallbackMode) {
            this.fallbackHandler.publish(record);
            return;
        }
        if (this.targetHandler != null) {
            this.targetHandler.publish(record);
            return;
        }
        List<LogRecord> list = this.logRecords;
        synchronized (list) {
            this.logRecords.add(record);
        }
        if (!this.fallbackMode && record.getLevel().intValue() >= this.fallbackPushLevel.intValue()) {
            this.fallbackMode = true;
            this.publishLogRecordsTo(this.fallbackHandler);
        }
    }

    public Handler getTargetHandler() {
        return this.targetHandler;
    }

    public void setTargetHandler(Handler targetHandler) {
        Assert.notNull(targetHandler, "Must specify a target handler");
        this.targetHandler = targetHandler;
        if (!this.fallbackMode) {
            this.publishLogRecordsTo(this.targetHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishLogRecordsTo(Handler destination) {
        List<LogRecord> list = this.logRecords;
        synchronized (list) {
            for (LogRecord record : this.logRecords) {
                destination.publish(record);
            }
            this.logRecords.clear();
        }
    }
}

