/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.shell.plugin.NamedProvider;

public final class PluginUtils {
    private PluginUtils() {
    }

    public static <T extends NamedProvider> T getHighestPriorityProvider(ApplicationContext applicationContext, Class<T> t) {
        Map<String, T> providers = BeanFactoryUtils.beansOfTypeIncludingAncestors(applicationContext, t);
        ArrayList<T> sortedProviders = new ArrayList<T>(providers.values());
        Collections.sort(sortedProviders, new AnnotationAwareOrderComparator());
        NamedProvider highestPriorityProvider = (NamedProvider)sortedProviders.get(0);
        return (T)highestPriorityProvider;
    }
}

