/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.event;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ParseResult {
    private final Method method;
    private final Object instance;
    private final Object[] arguments;

    public ParseResult(Method method, Object instance, Object[] arguments) {
        Assert.notNull(method, "Method required");
        Assert.notNull(instance, "Instance required");
        int length = arguments == null ? 0 : arguments.length;
        Assert.isTrue(method.getParameterTypes().length == length, "Required " + method.getParameterTypes().length + " arguments, but received " + length);
        this.method = method;
        this.instance = instance;
        this.arguments = arguments;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.arguments);
        result = 31 * result + (this.instance == null ? 0 : this.instance.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParseResult other = (ParseResult)obj;
        if (!Arrays.equals(this.arguments, other.arguments)) {
            return false;
        }
        if (this.instance == null ? other.instance != null : !this.instance.equals(other.instance)) {
            return false;
        }
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public String toString() {
        ToStringCreator tsc = new ToStringCreator(this);
        tsc.append("method", this.method);
        tsc.append("instance", this.instance);
        tsc.append("arguments", StringUtils.arrayToCommaDelimitedString(this.arguments));
        return tsc.toString();
    }
}

