/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.WindowsTerminal;
import jline.console.ConsoleReader;
import jline.console.history.History;
import jline.console.history.MemoryHistory;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.springframework.shell.core.AbstractShell;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.core.JLineLogHandler;
import org.springframework.shell.core.ParserCompleter;
import org.springframework.shell.core.Shell;
import org.springframework.shell.event.ShellStatus;
import org.springframework.shell.event.ShellStatusListener;
import org.springframework.shell.support.util.IOUtils;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.shell.support.util.VersionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class JLineShell
extends AbstractShell
implements Shell,
Runnable {
    private static final String ANSI_CONSOLE_CLASSNAME = "org.fusesource.jansi.AnsiConsole";
    private static final boolean JANSI_AVAILABLE = ClassUtils.isPresent("org.fusesource.jansi.AnsiConsole", JLineShell.class.getClassLoader());
    private static final char ESCAPE = '\u001b';
    private static final String BEL = "\u0007";
    protected ConsoleReader reader;
    private boolean developmentMode = false;
    private FileWriter fileLog;
    private final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    protected ShellStatusListener statusListener;
    private final Map<String, FlashInfo> flashInfoMap = new HashMap<String, FlashInfo>();
    private final Map<Integer, Integer> rowErasureMap = new HashMap<Integer, Integer>();
    private boolean shutdownHookFired = false;
    private int historySize;

    @Override
    public void run() {
        String[] filteredLogEntries;
        this.reader = this.createConsoleReader();
        this.setPromptPath(null);
        JLineLogHandler handler = new JLineLogHandler(this.reader, this);
        JLineLogHandler.prohibitRedraw();
        Logger mainLogger = Logger.getLogger("");
        this.removeHandlers(mainLogger);
        mainLogger.addHandler(handler);
        this.reader.addCompleter(new ParserCompleter(this.getParser()));
        this.reader.setBellEnabled(true);
        if (Boolean.getBoolean("jline.nobell")) {
            this.reader.setBellEnabled(false);
        }
        this.openFileLogIfPossible();
        History history = this.reader.getHistory();
        if (history instanceof MemoryHistory) {
            ((MemoryHistory)history).setMaxSize(this.getHistorySize());
        }
        for (String logEntry : filteredLogEntries = this.filterLogEntry()) {
            this.reader.getHistory().add(logEntry);
        }
        this.flashMessageRenderer();
        this.flash(Level.FINE, this.getProductName() + " " + this.getVersion(), "WINDOW_TITLE_SLOT");
        this.printBannerAndWelcome();
        String startupNotifications = this.getStartupNotifications();
        if (StringUtils.hasText(startupNotifications)) {
            this.logger.info(startupNotifications);
        }
        this.setShellStatus(ShellStatus.Status.STARTED);
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    JLineShell.this.shutdownHookFired = true;
                }
            }, this.getProductName() + " JLine Shutdown Hook"));
        }
        catch (Throwable t) {
            // empty catch block
        }
        String rooArgs = System.getProperty("roo.args");
        if (rooArgs != null && !"".equals(rooArgs)) {
            this.setShellStatus(ShellStatus.Status.USER_INPUT);
            boolean success = this.executeCommand(rooArgs).isSuccess();
            if (this.exitShellRequest == null) {
                this.executeCommand("quit");
                this.exitShellRequest = success ? ExitShellRequest.NORMAL_EXIT : ExitShellRequest.FATAL_EXIT;
            }
            this.setShellStatus(ShellStatus.Status.SHUTTING_DOWN);
        } else {
            this.promptLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] filterLogEntry() {
        ArrayList<String> entries = new ArrayList<String>();
        ReversedLinesFileReader reversedReader = null;
        try {
            reversedReader = new ReversedLinesFileReader(new File(this.getHistoryFileName()), 4096, Charset.forName("UTF-8"));
            int size = 0;
            String line = null;
            while ((line = reversedReader.readLine()) != null) {
                if (line.startsWith("//")) continue;
                if (++size > this.historySize) break;
                entries.add(line);
            }
            this.closeReversedReader(reversedReader);
        }
        catch (IOException e) {
            try {
                this.logger.warning("read history file failed. Reason:" + e.getMessage());
                this.closeReversedReader(reversedReader);
            }
            catch (Throwable throwable) {
                this.closeReversedReader(reversedReader);
                throw throwable;
            }
        }
        Collections.reverse(entries);
        return entries.toArray(new String[0]);
    }

    private void closeReversedReader(ReversedLinesFileReader reversedReader) {
        if (reversedReader != null) {
            try {
                reversedReader.close();
            }
            catch (IOException ex) {
                this.logger.warning("Cloud not close ReversedLinesFileReader: " + ex);
            }
        }
    }

    protected ConsoleReader createConsoleReader() {
        ConsoleReader consoleReader = null;
        try {
            if (this.isJansiAvailable()) {
                try {
                    consoleReader = this.createAnsiWindowsReader();
                }
                catch (Exception e) {
                    this.logger.warning("Can't initialize jansi AnsiConsole, falling back to default: " + e);
                }
            }
            if (consoleReader == null) {
                consoleReader = new ConsoleReader();
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Cannot start console class", ioe);
        }
        consoleReader.setExpandEvents(false);
        return consoleReader;
    }

    private boolean isJansiAvailable() {
        return JANSI_AVAILABLE && OsUtils.isWindows() && System.getProperty("jline.terminal") == null;
    }

    public void printBannerAndWelcome() {
    }

    public String getStartupNotifications() {
        return null;
    }

    private void removeHandlers(Logger l) {
        Handler[] handlers = l.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (Handler h : handlers) {
                l.removeHandler(h);
            }
        }
    }

    @Override
    public void setPromptPath(String path) {
        this.setPromptPath(path, false);
    }

    @Override
    public void setPromptPath(String path, boolean overrideStyle) {
        if (this.reader.getTerminal().isAnsiSupported()) {
            Ansi ansi = Ansi.ansi();
            if (path == null || "".equals(path)) {
                shellPrompt = ansi.fg(Ansi.Color.YELLOW).a(this.getPromptText()).reset().toString();
            } else {
                if (overrideStyle) {
                    ansi.a(path);
                } else {
                    ansi.fg(Ansi.Color.CYAN).a(path).reset();
                }
                shellPrompt = ansi.fg(Ansi.Color.YELLOW).a(" " + this.getPromptText()).toString();
            }
        } else {
            super.setPromptPath(path);
        }
        this.reader.setPrompt(AbstractShell.shellPrompt);
    }

    protected ConsoleReader createAnsiWindowsReader() throws Exception {
        final PrintStream ansiOut = (PrintStream)ClassUtils.forName(ANSI_CONSOLE_CLASSNAME, JLineShell.class.getClassLoader()).getMethod("out", new Class[0]).invoke(null, new Object[0]);
        WindowsTerminal ansiTerminal = new WindowsTerminal(){

            @Override
            public synchronized boolean isAnsiSupported() {
                return true;
            }
        };
        ansiTerminal.init();
        this.statusListener = new ShellStatusListener(){

            @Override
            public void onShellStatusChange(ShellStatus oldStatus, ShellStatus newStatus) {
                if (newStatus.getStatus().equals((Object)ShellStatus.Status.SHUTTING_DOWN)) {
                    ansiOut.close();
                }
            }
        };
        this.addShellStatusListener(this.statusListener);
        OutputStream out = AnsiConsole.wrapOutputStream(ansiOut);
        return new ConsoleReader(new FileInputStream(FileDescriptor.in), out, ansiTerminal);
    }

    private void flashMessageRenderer() {
        if (!this.reader.getTerminal().isAnsiSupported()) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!JLineShell.this.shellStatus.getStatus().equals((Object)ShellStatus.Status.SHUTTING_DOWN) && !JLineShell.this.shutdownHookFired) {
                    Map map = JLineShell.this.flashInfoMap;
                    synchronized (map) {
                        long now = System.currentTimeMillis();
                        HashSet<String> toRemove = new HashSet<String>();
                        for (String slot : JLineShell.this.flashInfoMap.keySet()) {
                            FlashInfo flashInfo = (FlashInfo)JLineShell.this.flashInfoMap.get(slot);
                            if (flashInfo.flashMessageUntil < now) {
                                toRemove.add(slot);
                                JLineShell.this.doAnsiFlash(flashInfo.rowNumber, Level.ALL, "");
                                continue;
                            }
                            JLineShell.this.doAnsiFlash(flashInfo.rowNumber, flashInfo.flashLevel, flashInfo.flashMessage);
                        }
                        for (String slot : toRemove) {
                            JLineShell.this.flashInfoMap.remove(slot);
                        }
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, this.getProductName() + " JLine Flash Message Manager");
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flash(Level level, String message, String slot) {
        Assert.notNull(level, "Level is required for a flash message");
        Assert.notNull(message, "Message is required for a flash message");
        Assert.hasText(slot, "Slot name must be specified for a flash message");
        if ("WINDOW_TITLE_SLOT".equals(slot)) {
            if (this.reader != null && this.reader.getTerminal().isAnsiSupported()) {
                if (!StringUtils.hasText(message)) {
                    System.out.println("No text");
                }
                Ansi ansi = Ansi.ansi();
                ansi.a("\u001b]0;").a(message).a(BEL);
                try {
                    this.reader.print(ansi.toString());
                    this.reader.flush();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            return;
        }
        if (this.reader != null && !this.reader.getTerminal().isAnsiSupported()) {
            super.flash(level, message, slot);
            return;
        }
        Map<String, FlashInfo> map = this.flashInfoMap;
        synchronized (map) {
            FlashInfo flashInfo = this.flashInfoMap.get(slot);
            if ("".equals(message)) {
                if (flashInfo == null) {
                    return;
                }
                flashInfo.flashMessageUntil = System.currentTimeMillis() + 1500L;
            } else {
                if (flashInfo == null) {
                    flashInfo = new FlashInfo();
                    flashInfo.rowNumber = Integer.MAX_VALUE;
                    block5: for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                        for (FlashInfo existingFlashInfo : this.flashInfoMap.values()) {
                            if (existingFlashInfo.rowNumber != i) continue;
                            continue block5;
                        }
                        flashInfo.rowNumber = i;
                        break;
                    }
                    this.flashInfoMap.put(slot, flashInfo);
                }
                flashInfo.flashMessageUntil = Long.MAX_VALUE;
                flashInfo.flashLevel = level;
                flashInfo.flashMessage = message;
                this.doAnsiFlash(flashInfo.rowNumber, flashInfo.flashLevel, flashInfo.flashMessage);
            }
        }
    }

    private void doAnsiFlash(int row, Level level, String message) {
        Ansi ansi = Ansi.ansi();
        if (JLineShell.isAppleTerminal()) {
            ansi.a("\u001b7");
        } else {
            ansi.saveCursorPosition();
        }
        int mostFurtherLeftColNumber = Integer.MAX_VALUE;
        for (Integer candidate : this.rowErasureMap.values()) {
            if (candidate >= mostFurtherLeftColNumber) continue;
            mostFurtherLeftColNumber = candidate;
        }
        if (mostFurtherLeftColNumber != Integer.MAX_VALUE) {
            ansi.cursor(row, mostFurtherLeftColNumber);
            ansi.eraseLine(Ansi.Erase.FORWARD);
        }
        if ("".equals(message)) {
            this.rowErasureMap.remove(row);
        } else {
            if (this.shutdownHookFired) {
                return;
            }
            int startFrom = this.reader.getTerminal().getWidth() - message.length() + 1;
            if (startFrom < 1) {
                startFrom = 1;
            }
            ansi.cursor(row, startFrom);
            ansi.a(Ansi.Attribute.NEGATIVE_ON).a(message).a(Ansi.Attribute.NEGATIVE_OFF);
            this.rowErasureMap.put(row, startFrom);
        }
        if (JLineShell.isAppleTerminal()) {
            ansi.a("\u001b8");
        } else {
            ansi.reset();
        }
        try {
            this.reader.print(ansi.toString());
            this.reader.flush();
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    @Override
    public void promptLoop() {
        this.setShellStatus(ShellStatus.Status.USER_INPUT);
        String prompt = this.getPromptText();
        try {
            String line;
            while (this.exitShellRequest == null && this.reader != null && (line = this.reader.readLine()) != null) {
                JLineLogHandler.resetMessageTracking();
                this.setShellStatus(ShellStatus.Status.USER_INPUT);
                if (!StringUtils.hasText(line)) {
                    prompt = this.generatePromptUpdate(prompt);
                    continue;
                }
                this.executeCommand(line);
                prompt = this.generatePromptUpdate(prompt);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Shell line reading failure", ioe);
        }
        this.setShellStatus(ShellStatus.Status.SHUTTING_DOWN);
    }

    public String generatePromptUpdate(String existingPrompt) {
        String newPrompt = this.getPromptText();
        if (!ObjectUtils.nullSafeEquals(existingPrompt, newPrompt)) {
            this.setPromptPath(null);
        }
        return newPrompt;
    }

    @Override
    public void setDevelopmentMode(boolean developmentMode) {
        JLineLogHandler.setIncludeThreadName(developmentMode);
        JLineLogHandler.setSuppressDuplicateMessages(!developmentMode);
        this.developmentMode = developmentMode;
    }

    @Override
    public boolean isDevelopmentMode() {
        return this.developmentMode;
    }

    private void openFileLogIfPossible() {
        try {
            this.fileLog = new FileWriter(this.getHistoryFileName(), true);
            this.fileLog.write("// " + this.getProductName() + " " + this.versionInfo() + " log opened at " + this.df.format(new Date()) + "\n");
            this.fileLog.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void logCommandToOutput(String processedLine) {
        if (this.fileLog == null) {
            this.openFileLogIfPossible();
            if (this.fileLog == null) {
                return;
            }
        }
        try {
            this.fileLog.write(processedLine + "\n");
            this.fileLog.flush();
            if (this.getExitShellRequest() != null) {
                this.fileLog.write("// " + this.getProductName() + " " + this.versionInfo() + " log closed at " + this.df.format(new Date()) + "\n");
                IOUtils.closeQuietly(this.fileLog);
                this.fileLog = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected String getHomeAsString() {
        String rooHome = System.getProperty("roo.home");
        if (rooHome == null) {
            try {
                rooHome = new File(".").getCanonicalPath();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return rooHome;
    }

    protected void closeShell() {
        this.setShellStatus(ShellStatus.Status.SHUTTING_DOWN);
        if (this.statusListener != null) {
            this.removeShellStatusListener(this.statusListener);
        }
    }

    protected abstract String getHistoryFileName();

    protected abstract String getPromptText();

    protected abstract String getProductName();

    protected String getVersion() {
        return VersionUtils.versionInfo();
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        this.historySize = historySize;
    }

    private static boolean isAppleTerminal() {
        String terminalName = System.getenv("TERM_PROGRAM");
        return "Apple_Terminal".equalsIgnoreCase(terminalName) || Boolean.getBoolean("is.apple.terminal");
    }

    private static class FlashInfo {
        String flashMessage;
        long flashMessageUntil;
        Level flashLevel;
        int rowNumber;

        private FlashInfo() {
        }
    }
}

