/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.Property;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class TypeDescriptor
implements Serializable {
    static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final Map<Class<?>, TypeDescriptor> commonTypesCache = new HashMap();
    private static final Class<?>[] CACHED_COMMON_TYPES;
    private final Class<?> type;
    private final ResolvableType resolvableType;
    private final Annotation[] annotations;

    public TypeDescriptor(MethodParameter methodParameter) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        if (methodParameter.getNestingLevel() != 1) {
            throw new IllegalArgumentException("MethodParameter argument must have its nestingLevel set to 1");
        }
        this.resolvableType = ResolvableType.forMethodParameter(methodParameter);
        this.type = this.resolvableType.resolve(methodParameter.getParameterType());
        this.annotations = methodParameter.getParameterIndex() == -1 ? this.nullSafeAnnotations(methodParameter.getMethodAnnotations()) : this.nullSafeAnnotations(methodParameter.getParameterAnnotations());
    }

    public TypeDescriptor(Field field) {
        Assert.notNull(field, "Field must not be null");
        this.resolvableType = ResolvableType.forField(field);
        this.type = this.resolvableType.resolve(field.getType());
        this.annotations = this.nullSafeAnnotations(field.getAnnotations());
    }

    public TypeDescriptor(Property property) {
        Assert.notNull(property, "Property must not be null");
        this.resolvableType = ResolvableType.forMethodParameter(property.getMethodParameter());
        this.type = this.resolvableType.resolve(property.getType());
        this.annotations = this.nullSafeAnnotations(property.getAnnotations());
    }

    protected TypeDescriptor(ResolvableType resolvableType, Class<?> type, Annotation[] annotations) {
        this.resolvableType = resolvableType;
        this.type = type != null ? type : resolvableType.resolve(Object.class);
        this.annotations = this.nullSafeAnnotations(annotations);
    }

    private Annotation[] nullSafeAnnotations(Annotation[] annotations) {
        return annotations != null ? annotations : EMPTY_ANNOTATION_ARRAY;
    }

    public Class<?> getObjectType() {
        return ClassUtils.resolvePrimitiveIfNecessary(this.getType());
    }

    public Class<?> getType() {
        return this.type;
    }

    public ResolvableType getResolvableType() {
        return this.resolvableType;
    }

    public Object getSource() {
        return this.resolvableType == null ? null : this.resolvableType.getSource();
    }

    public TypeDescriptor narrow(Object value) {
        if (value == null) {
            return this;
        }
        ResolvableType narrowed = ResolvableType.forType(value.getClass(), this.resolvableType);
        return new TypeDescriptor(narrowed, null, this.annotations);
    }

    public TypeDescriptor upcast(Class<?> superType) {
        if (superType == null) {
            return null;
        }
        Assert.isAssignable(superType, this.getType());
        return new TypeDescriptor(this.resolvableType.as(superType), superType, this.annotations);
    }

    public String getName() {
        return ClassUtils.getQualifiedName(this.getType());
    }

    public boolean isPrimitive() {
        return this.getType().isPrimitive();
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (T)annotation;
        }
        for (Annotation metaAnn : this.getAnnotations()) {
            T ann = metaAnn.annotationType().getAnnotation(annotationType);
            if (ann == null) continue;
            return ann;
        }
        return null;
    }

    public boolean isAssignableTo(TypeDescriptor typeDescriptor) {
        boolean typesAssignable = typeDescriptor.getObjectType().isAssignableFrom(this.getObjectType());
        if (!typesAssignable) {
            return false;
        }
        if (this.isArray() && typeDescriptor.isArray()) {
            return this.getElementTypeDescriptor().isAssignableTo(typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isCollection() && typeDescriptor.isCollection()) {
            return this.isNestedAssignable(this.getElementTypeDescriptor(), typeDescriptor.getElementTypeDescriptor());
        }
        if (this.isMap() && typeDescriptor.isMap()) {
            return this.isNestedAssignable(this.getMapKeyTypeDescriptor(), typeDescriptor.getMapKeyTypeDescriptor()) && this.isNestedAssignable(this.getMapValueTypeDescriptor(), typeDescriptor.getMapValueTypeDescriptor());
        }
        return true;
    }

    private boolean isNestedAssignable(TypeDescriptor nestedTypeDescriptor, TypeDescriptor otherNestedTypeDescriptor) {
        if (nestedTypeDescriptor == null || otherNestedTypeDescriptor == null) {
            return true;
        }
        return nestedTypeDescriptor.isAssignableTo(otherNestedTypeDescriptor);
    }

    public boolean isCollection() {
        return Collection.class.isAssignableFrom(this.getType());
    }

    public boolean isArray() {
        return this.getType().isArray();
    }

    public TypeDescriptor getElementTypeDescriptor() {
        if (this.resolvableType.isArray()) {
            return new TypeDescriptor(this.resolvableType.getComponentType(), null, this.annotations);
        }
        return TypeDescriptor.getRelatedIfResolvable(this, this.resolvableType.asCollection().getGeneric(new int[0]));
    }

    public TypeDescriptor elementTypeDescriptor(Object element) {
        return this.narrow(element, this.getElementTypeDescriptor());
    }

    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    public TypeDescriptor getMapKeyTypeDescriptor() {
        Assert.state(this.isMap(), "Not a java.util.Map");
        return TypeDescriptor.getRelatedIfResolvable(this, this.resolvableType.asMap().getGeneric(0));
    }

    public TypeDescriptor getMapKeyTypeDescriptor(Object mapKey) {
        return this.narrow(mapKey, this.getMapKeyTypeDescriptor());
    }

    public TypeDescriptor getMapValueTypeDescriptor() {
        Assert.state(this.isMap(), "Not a java.util.Map");
        return TypeDescriptor.getRelatedIfResolvable(this, this.resolvableType.asMap().getGeneric(1));
    }

    public TypeDescriptor getMapValueTypeDescriptor(Object mapValue) {
        return this.narrow(mapValue, this.getMapValueTypeDescriptor());
    }

    @Deprecated
    public Class<?> getElementType() {
        return this.getType(this.getElementTypeDescriptor());
    }

    @Deprecated
    public Class<?> getMapKeyType() {
        return this.getType(this.getMapKeyTypeDescriptor());
    }

    @Deprecated
    public Class<?> getMapValueType() {
        return this.getType(this.getMapValueTypeDescriptor());
    }

    private Class<?> getType(TypeDescriptor typeDescriptor) {
        return typeDescriptor != null ? typeDescriptor.getType() : null;
    }

    private TypeDescriptor narrow(Object value, TypeDescriptor typeDescriptor) {
        if (typeDescriptor != null) {
            return typeDescriptor.narrow(value);
        }
        return value != null ? new TypeDescriptor(this.resolvableType, value.getClass(), this.annotations) : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeDescriptor)) {
            return false;
        }
        TypeDescriptor other = (TypeDescriptor)obj;
        if (!ObjectUtils.nullSafeEquals(this.type, other.type)) {
            return false;
        }
        if (this.getAnnotations().length != other.getAnnotations().length) {
            return false;
        }
        for (Annotation ann : this.getAnnotations()) {
            if (other.getAnnotation(ann.annotationType()) != null) continue;
            return false;
        }
        if (this.isCollection() || this.isArray()) {
            return ObjectUtils.nullSafeEquals(this.getElementTypeDescriptor(), other.getElementTypeDescriptor());
        }
        if (this.isMap()) {
            return ObjectUtils.nullSafeEquals(this.getMapKeyTypeDescriptor(), other.getMapKeyTypeDescriptor()) && ObjectUtils.nullSafeEquals(this.getMapValueTypeDescriptor(), other.getMapValueTypeDescriptor());
        }
        return true;
    }

    public int hashCode() {
        return this.getType().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Annotation ann : this.getAnnotations()) {
            builder.append("@").append(ann.annotationType().getName()).append(' ');
        }
        builder.append(this.resolvableType.toString());
        return builder.toString();
    }

    public static TypeDescriptor valueOf(Class<?> type) {
        TypeDescriptor desc;
        if (type == null) {
            type = Object.class;
        }
        return (desc = commonTypesCache.get(type)) != null ? desc : new TypeDescriptor(ResolvableType.forClass(type), null, null);
    }

    public static TypeDescriptor collection(Class<?> collectionType, TypeDescriptor elementTypeDescriptor) {
        Assert.notNull(collectionType, "collectionType must not be null");
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException("collectionType must be a java.util.Collection");
        }
        ResolvableType element = elementTypeDescriptor != null ? elementTypeDescriptor.resolvableType : null;
        return new TypeDescriptor(ResolvableType.forClassWithGenerics(collectionType, element), null, null);
    }

    public static TypeDescriptor map(Class<?> mapType, TypeDescriptor keyTypeDescriptor, TypeDescriptor valueTypeDescriptor) {
        if (!Map.class.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException("mapType must be a java.util.Map");
        }
        ResolvableType key = keyTypeDescriptor != null ? keyTypeDescriptor.resolvableType : null;
        ResolvableType value = valueTypeDescriptor != null ? valueTypeDescriptor.resolvableType : null;
        return new TypeDescriptor(ResolvableType.forClassWithGenerics(mapType, key, value), null, null);
    }

    public static TypeDescriptor array(TypeDescriptor elementTypeDescriptor) {
        if (elementTypeDescriptor == null) {
            return null;
        }
        return new TypeDescriptor(ResolvableType.forArrayComponent(elementTypeDescriptor.resolvableType), null, elementTypeDescriptor.getAnnotations());
    }

    public static TypeDescriptor nested(MethodParameter methodParameter, int nestingLevel) {
        if (methodParameter.getNestingLevel() != 1) {
            throw new IllegalArgumentException("MethodParameter nesting level must be 1: use the nestingLevel parameter to specify the desired nestingLevel for nested type traversal");
        }
        return TypeDescriptor.nested(new TypeDescriptor(methodParameter), nestingLevel);
    }

    public static TypeDescriptor nested(Field field, int nestingLevel) {
        return TypeDescriptor.nested(new TypeDescriptor(field), nestingLevel);
    }

    public static TypeDescriptor nested(Property property, int nestingLevel) {
        return TypeDescriptor.nested(new TypeDescriptor(property), nestingLevel);
    }

    public static TypeDescriptor forObject(Object source) {
        return source != null ? TypeDescriptor.valueOf(source.getClass()) : null;
    }

    private static TypeDescriptor nested(TypeDescriptor typeDescriptor, int nestingLevel) {
        ResolvableType nested = typeDescriptor.resolvableType;
        for (int i = 0; i < nestingLevel; ++i) {
            if (Object.class.equals((Object)nested.getType())) continue;
            nested = nested.getNested(2);
        }
        if (nested == ResolvableType.NONE) {
            throw new IllegalStateException("Unable to obtain nested generic from " + typeDescriptor + " at level " + nestingLevel);
        }
        return TypeDescriptor.getRelatedIfResolvable(typeDescriptor, nested);
    }

    private static TypeDescriptor getRelatedIfResolvable(TypeDescriptor source, ResolvableType type) {
        if (type.resolve() == null) {
            return null;
        }
        return new TypeDescriptor(type, null, source.annotations);
    }

    static {
        for (Class<?> preCachedClass : CACHED_COMMON_TYPES = new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Short.TYPE, Short.class, String.class, Object.class}) {
            commonTypesCache.put(preCachedClass, TypeDescriptor.valueOf(preCachedClass));
        }
    }
}

