/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.workflow.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OozieActionConfigurationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OozieActionConfigurationHelper.class);

    private OozieActionConfigurationHelper() {
    }

    public static Configuration createActionConf() throws IOException {
        String tokenFile;
        Configuration conf = new Configuration();
        Path confPath = new Path("file:///" + System.getProperty("oozie.action.conf.xml"));
        boolean actionConfExists = confPath.getFileSystem(conf).exists(confPath);
        LOG.info("Oozie Action conf {} found ? {}", (Object)confPath, (Object)actionConfExists);
        if (actionConfExists) {
            LOG.info("Oozie Action conf found, adding path={}, conf={}", (Object)confPath, (Object)conf.toString());
            conf.addResource(confPath);
            OozieActionConfigurationHelper.dumpConf(conf, "oozie action conf ");
        }
        if ((tokenFile = System.getenv("HADOOP_TOKEN_FILE_LOCATION")) != null) {
            if (Shell.WINDOWS) {
                if (tokenFile.charAt(0) == '\"') {
                    tokenFile = tokenFile.substring(1);
                }
                if (tokenFile.charAt(tokenFile.length() - 1) == '\"') {
                    tokenFile = tokenFile.substring(0, tokenFile.length() - 1);
                }
            }
            conf.set("mapreduce.job.credentials.binary", tokenFile);
            System.setProperty("mapreduce.job.credentials.binary", tokenFile);
            conf.set("tez.credentials.path", tokenFile);
            System.setProperty("tez.credentials.path", tokenFile);
        }
        conf.set("datanucleus.plugin.pluginRegistryBundleCheck", "LOG");
        conf.setBoolean("hive.exec.mode.local.auto", false);
        return conf;
    }

    public static void dumpConf(Configuration conf, String message) throws IOException {
        StringWriter writer = new StringWriter();
        Configuration.dumpConfiguration((Configuration)conf, (Writer)writer);
        LOG.info(message + " {}", (Object)writer);
    }
}

