/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.falcon.FalconException;
import org.apache.falcon.util.ApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuntimeProperties
extends ApplicationProperties {
    private static final Logger LOG = LoggerFactory.getLogger(RuntimeProperties.class);
    private static final String PROPERTY_FILE = "runtime.properties";
    private static final AtomicReference<RuntimeProperties> INSTANCE = new AtomicReference();

    private RuntimeProperties() throws FalconException {
    }

    @Override
    protected String getPropertyFile() {
        return PROPERTY_FILE;
    }

    public static Properties get() {
        try {
            if (INSTANCE.get() == null) {
                RuntimeProperties properties = new RuntimeProperties();
                properties.loadProperties();
                properties.validateProperties();
                INSTANCE.compareAndSet(null, properties);
                if (INSTANCE.get() == properties) {
                    Thread refreshThread = new Thread(new DynamicLoader());
                    refreshThread.start();
                }
            }
            return INSTANCE.get();
        }
        catch (FalconException e) {
            throw new RuntimeException("Unable to read application runtime properties", e);
        }
    }

    protected void validateProperties() throws FalconException {
        String colosProp = this.getProperty("all.colos");
        if (colosProp == null || colosProp.isEmpty()) {
            return;
        }
        String[] colos = colosProp.split(",");
        for (int i = 0; i < colos.length; ++i) {
            colos[i] = colos[i].trim();
            String falconEndpoint = this.getProperty("falcon." + colos[i] + ".endpoint");
            if (falconEndpoint != null && !falconEndpoint.isEmpty()) continue;
            throw new FalconException("No falcon server endpoint mentioned in Prism runtime for colo, " + colos[i] + ".");
        }
    }

    private static final class DynamicLoader
    implements Runnable {
        private static final long REFRESH_DELAY = 300000L;
        private static final int MAX_ITER = 20;

        private DynamicLoader() {
        }

        @Override
        public void run() {
            long backOffDelay = 300000L;
            block4: while (true) {
                try {
                    while (true) {
                        Thread.sleep(Math.min(6000000L, backOffDelay));
                        try {
                            RuntimeProperties newProperties = new RuntimeProperties();
                            newProperties.loadProperties();
                            newProperties.validateProperties();
                            INSTANCE.set(newProperties);
                            backOffDelay = 300000L;
                            continue block4;
                        }
                        catch (FalconException e) {
                            LOG.warn("Error refreshing runtime properties", (Throwable)e);
                            backOffDelay += 300000L;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    LOG.error("Application is stopping. Aborting...");
                    return;
                }
            }
        }
    }
}

