/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.falcon.FalconException;
import org.apache.falcon.util.StartupProperties;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static <T> T getInstance(String classKey) throws FalconException {
        return ReflectionUtils.getInstanceByClassName(StartupProperties.get().getProperty(classKey));
    }

    public static <T> T getInstance(String classKey, Class<?> argCls, Object arg) throws FalconException {
        return ReflectionUtils.getInstanceByClassName(StartupProperties.get().getProperty(classKey), argCls, arg);
    }

    public static <T> T getInstanceByClassName(String clazzName) throws FalconException {
        try {
            Class<?> clazz = ReflectionUtils.class.getClassLoader().loadClass(clazzName);
            try {
                return (T)clazz.newInstance();
            }
            catch (IllegalAccessException e) {
                Method method = clazz.getMethod("get", new Class[0]);
                return (T)method.invoke(null, new Object[0]);
            }
        }
        catch (Exception e) {
            throw new FalconException("Unable to get instance for " + clazzName, e);
        }
    }

    public static <T> T getInstanceByClassName(String clazzName, Class<?> argCls, Object arg) throws FalconException {
        try {
            Class<?> clazz = ReflectionUtils.class.getClassLoader().loadClass(clazzName);
            Constructor<?> constructor = clazz.getConstructor(argCls);
            return (T)constructor.newInstance(arg);
        }
        catch (Exception e) {
            throw new FalconException("Unable to get instance for " + clazzName, e);
        }
    }
}

