/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.falcon.FalconException;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HadoopQueueUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopQueueUtil.class);

    private HadoopQueueUtil() {
    }

    public static String getHadoopClusterSchedulerInfo(String rmBaseUrlStr) throws FalconException {
        String string;
        KerberosAuthenticator kAUTHENTICATOR = new KerberosAuthenticator();
        AuthenticatedURL.Token authenticationToken = new AuthenticatedURL.Token();
        String rmSchedulerInfoURL = rmBaseUrlStr;
        if (!rmSchedulerInfoURL.endsWith("/")) {
            rmSchedulerInfoURL = rmSchedulerInfoURL + "/";
        }
        rmSchedulerInfoURL = rmSchedulerInfoURL + "ws/v1/cluster/scheduler";
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            String line;
            URL url = new URL(rmSchedulerInfoURL);
            conn = new AuthenticatedURL((Authenticator)kAUTHENTICATOR).openConnection(url, authenticationToken);
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder jsonResponse = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                jsonResponse.append(line);
            }
            string = jsonResponse.toString();
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Could not authenticate, " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly(reader);
        if (conn != null) {
            conn.disconnect();
        }
        return string;
    }

    public static Set<String> getHadoopClusterQueueNamesHelper(String jsonResult, Set<String> qNames) throws JSONException {
        String qJson = HadoopQueueUtil.extractRootQueuesElement(jsonResult);
        LOG.debug("Extracted Queue JSON - {}", (Object)qJson);
        JSONObject jObject = new JSONObject(qJson);
        LOG.debug("Parsing Json result done");
        JSONObject queues = jObject.getJSONObject("queues");
        HadoopQueueUtil.jsonParseForHadoopQueueNames(queues, qNames);
        return qNames;
    }

    public static void jsonParseForHadoopQueueNames(JSONObject queues, Set<String> qNames) throws JSONException {
        JSONArray qs = queues.getJSONArray("queue");
        for (int i = 0; i < qs.length(); ++i) {
            JSONObject q = qs.getJSONObject(i);
            qNames.add(q.getString("queueName"));
            if (!q.isNull("type") && q.getString("type").equalsIgnoreCase("capacitySchedulerLeafQueueInfo")) continue;
            HadoopQueueUtil.jsonParseForHadoopQueueNames(q.getJSONObject("queues"), qNames);
        }
    }

    public static String extractRootQueuesElement(String json) {
        int start;
        int i = start = json.indexOf("\"queues\":");
        while (json.charAt(i) != '{') {
            ++i;
        }
        ++i;
        int count = 1;
        while (count != 0) {
            if (json.charAt(i) == '{') {
                ++count;
            } else if (json.charAt(i) == '}') {
                --count;
            }
            ++i;
        }
        return "{" + json.substring(start, i) + "}";
    }

    public static Set<String> getHadoopClusterQueueNames(String rmBaseUrlStr) throws FalconException {
        String jsonResult = HadoopQueueUtil.getHadoopClusterSchedulerInfo(rmBaseUrlStr);
        LOG.debug("Scheduler Info Result : {} ", (Object)jsonResult);
        HashSet<String> qNames = new HashSet<String>();
        try {
            return HadoopQueueUtil.getHadoopClusterQueueNamesHelper(jsonResult, qNames);
        }
        catch (JSONException jex) {
            throw new FalconException(jex);
        }
    }
}

