/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.falcon.entity.ColoClusterRelation;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.util.DeploymentProperties;
import org.apache.falcon.util.StartupProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeploymentUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentUtil.class);
    protected static final String DEFAULT_COLO = "default";
    protected static final String EMBEDDED = "embedded";
    protected static final String DEPLOY_MODE = "deploy.mode";
    private static final Set<String> DEFAULT_ALL_COLOS = new HashSet<String>();
    protected static final String CURRENT_COLO;
    protected static final boolean EMBEDDED_MODE;
    private static boolean prism;

    private DeploymentUtil() {
    }

    public static void setPrismMode() {
        prism = true;
    }

    public static boolean isPrism() {
        return !EMBEDDED_MODE && prism;
    }

    public static String getCurrentColo() {
        return CURRENT_COLO;
    }

    public static Set<String> getCurrentClusters() {
        if (EMBEDDED_MODE) {
            Collection<String> allClusters = ConfigurationStore.get().getEntities(EntityType.CLUSTER);
            HashSet<String> result = new HashSet<String>(allClusters);
            return result;
        }
        String colo = DeploymentUtil.getCurrentColo();
        return ColoClusterRelation.get().getClusters(colo);
    }

    public static boolean isEmbeddedMode() {
        return EMBEDDED_MODE;
    }

    public static String getDefaultColo() {
        return DEFAULT_COLO;
    }

    public static Set<String> getDefaultColos() {
        DEFAULT_ALL_COLOS.add(DEFAULT_COLO);
        return DEFAULT_ALL_COLOS;
    }

    static {
        prism = false;
        DEFAULT_ALL_COLOS.add(DEFAULT_COLO);
        EMBEDDED_MODE = DeploymentProperties.get().getProperty(DEPLOY_MODE, EMBEDDED).equals(EMBEDDED);
        CURRENT_COLO = EMBEDDED_MODE ? DEFAULT_COLO : StartupProperties.get().getProperty("current.colo", DEFAULT_COLO);
        LOG.info("Running in embedded mode? {}", (Object)EMBEDDED_MODE);
        LOG.info("Current colo: {}", (Object)CURRENT_COLO);
    }
}

