/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.retention;

import java.util.Date;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.apache.commons.el.ExpressionEvaluatorImpl;
import org.apache.falcon.Pair;
import org.apache.falcon.expression.ExpressionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvictionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EvictionHelper.class);
    private static final ExpressionEvaluator EVALUATOR = new ExpressionEvaluatorImpl();
    private static final ExpressionHelper RESOLVER = ExpressionHelper.get();

    private EvictionHelper() {
    }

    public static Pair<Date, Date> getDateRange(String period) throws ELException {
        Long duration = EvictionHelper.evalExpressionToMilliSeconds(period);
        Date end = new Date();
        Date start = new Date(end.getTime() - duration);
        return Pair.of(start, end);
    }

    public static Long evalExpressionToMilliSeconds(String period) throws ELException {
        return (Long)EVALUATOR.evaluate("${" + period + "}", Long.class, (VariableResolver)RESOLVER, (FunctionMapper)RESOLVER);
    }
}

