/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.resource;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement(name="result")
@XmlAccessorType(value=XmlAccessType.FIELD)
@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class LineageGraphResult {
    private String[] vertices;
    @XmlElement(name="edges")
    private Edge[] edges;
    private static final JAXBContext JAXB_CONTEXT;

    public String getDotNotation() {
        StringBuilder result = new StringBuilder();
        result.append("digraph g{ \n");
        if (this.vertices != null) {
            for (String v : this.vertices) {
                result.append("\"" + (String)v + "\"");
                result.append("\n");
            }
        }
        if (this.edges != null) {
            for (Edge e : this.edges) {
                result.append(e.getDotNotation());
            }
        }
        result.append("}\n");
        return result.toString();
    }

    public String[] getVertices() {
        return this.vertices;
    }

    public void setVertices(String[] vertices) {
        this.vertices = vertices;
    }

    public Edge[] getEdges() {
        return this.edges;
    }

    public void setEdges(Edge[] edges) {
        this.edges = edges;
    }

    public String toString() {
        return this.getDotNotation();
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{LineageGraphResult.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @XmlRootElement(name="edge")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class Edge {
        @XmlElement
        private String from;
        @XmlElement
        private String to;
        @XmlElement
        private String label;

        public Edge() {
        }

        public Edge(String from, String to, String label) {
            this.from = from;
            this.to = to;
            this.label = label;
        }

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getDotNotation() {
            StringBuilder result = new StringBuilder();
            if (StringUtils.isNotBlank(this.from) && StringUtils.isNotBlank(this.to) && StringUtils.isNotBlank(this.label)) {
                result.append("\"" + this.from + "\"");
                result.append(" -> ");
                result.append("\"" + this.to + "\"");
                result.append(" [ label = \"" + this.label + "\" ] \n");
            }
            return result.toString();
        }

        public String toString() {
            return this.getDotNotation();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Edge that = (Edge)o;
            return StringUtils.equals(that.getLabel(), this.label) && StringUtils.equals(that.getFrom(), this.from) && StringUtils.equals(that.getTo(), this.to);
        }

        public int hashCode() {
            int result = this.from != null ? this.from.hashCode() : 0;
            result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            return result;
        }
    }
}

