/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.resource;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.falcon.resource.APIResult;

@XmlRootElement
@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class InstancesSummaryResult
extends APIResult {
    @XmlElement
    private InstanceSummary[] instancesSummary;

    private InstancesSummaryResult() {
    }

    public InstancesSummaryResult(APIResult.Status status, String message) {
        super(status, message);
    }

    public InstanceSummary[] getInstancesSummary() {
        return this.instancesSummary;
    }

    public void setInstancesSummary(InstanceSummary[] instancesSummary) {
        this.instancesSummary = instancesSummary;
    }

    @Override
    public Object[] getCollection() {
        return this.getInstancesSummary();
    }

    @Override
    public void setCollection(Object[] items) {
        if (items == null) {
            this.setInstancesSummary(new InstanceSummary[0]);
        } else {
            InstanceSummary[] newInstances = new InstanceSummary[items.length];
            for (int index = 0; index < items.length; ++index) {
                newInstances[index] = (InstanceSummary)items[index];
            }
            this.setInstancesSummary(newInstances);
        }
    }

    @XmlRootElement(name="instance-summary")
    public static class InstanceSummary {
        @XmlElement
        public String cluster;
        @XmlElementWrapper(name="map")
        public Map<String, Long> summaryMap;

        public InstanceSummary() {
        }

        public InstanceSummary(String cluster, Map<String, Long> summaryMap) {
            this.cluster = cluster;
            this.summaryMap = summaryMap;
        }

        public Map<String, Long> getSummaryMap() {
            return this.summaryMap;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String toString() {
            return "cluster: " + (this.cluster == null ? "" : this.cluster) + "summaryMap: " + this.summaryMap.toString();
        }
    }

    public static enum InstanceSummaryFilterFields {
        STATUS,
        CLUSTER;

    }
}

