/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.resource;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.falcon.resource.EntityList;
import org.apache.falcon.resource.InstancesResult;

@XmlRootElement
@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class ExtensionInstanceList {
    @XmlElement
    public int numEntities;
    @XmlElementWrapper(name="entitiesSummary")
    public List<EntitySummary> entitySummary;

    public ExtensionInstanceList() {
        this.numEntities = 0;
        this.entitySummary = null;
    }

    public ExtensionInstanceList(int numEntities) {
        this.numEntities = numEntities;
        this.entitySummary = new ArrayList<EntitySummary>();
    }

    public ExtensionInstanceList(int numEntities, List<EntitySummary> entitySummary) {
        this.numEntities = numEntities;
        this.entitySummary = entitySummary;
    }

    public void addEntitySummary(EntitySummary summary) {
        this.entitySummary.add(summary);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.numEntities + "\n\n");
        for (EntitySummary summary : this.entitySummary) {
            buffer.append(summary.toString());
        }
        return buffer.toString();
    }

    public static class EntitySummary {
        @XmlElement
        public EntityList.EntityElement entityProfile;
        @XmlElement
        public InstancesResult.Instance[] instances;

        public EntitySummary() {
            this.entityProfile = null;
            this.instances = null;
        }

        public EntitySummary(EntityList.EntityElement entityProfile, InstancesResult.Instance[] instances) {
            this.entityProfile = entityProfile;
            this.instances = instances;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.entityProfile.toString() + "\n");
            buffer.append(Arrays.toString(this.instances) + "\n");
            return buffer.toString();
        }
    }
}

