/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.falcon.FalconException;
import org.apache.falcon.service.FalconService;
import org.apache.falcon.util.StartupProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricNotificationService
implements FalconService {
    private static final Logger LOG = LoggerFactory.getLogger(MetricNotificationService.class);
    public static final String SERVICE_NAME = MetricNotificationService.class.getSimpleName();
    private static final MetricNotificationService METRIC_NOTIFICATION_SERVICE = new MetricNotificationService();
    private final GraphiteReporter graphiteReporter;
    private final MetricRegistry metricRegistry;
    private Map<String, MetricGauge> metricMap = new ConcurrentHashMap<String, MetricGauge>();

    public static MetricNotificationService get() {
        return METRIC_NOTIFICATION_SERVICE;
    }

    public MetricNotificationService() {
        Graphite graphite = new Graphite(new InetSocketAddress(StartupProperties.get().getProperty("falcon.graphite.hostname"), Integer.parseInt(StartupProperties.get().getProperty("falcon.graphite.port"))));
        this.metricRegistry = new MetricRegistry();
        this.graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry).convertDurationsTo(TimeUnit.SECONDS).filter(MetricFilter.ALL).build(graphite);
    }

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    @Override
    public void init() throws FalconException {
        LOG.info("Starting Graphite Service");
        this.graphiteReporter.start(Long.parseLong(StartupProperties.get().getProperty("falcon.graphite.frequency")), TimeUnit.SECONDS);
    }

    @Override
    public void destroy() throws FalconException {
        this.graphiteReporter.stop();
    }

    private MetricGauge createMetric(String metricName) {
        if (!this.metricMap.containsKey(metricName)) {
            MetricGauge metricGauge = new MetricGauge();
            this.metricMap.put(metricName, metricGauge);
            this.metricRegistry.register(metricName, (Metric)metricGauge);
        }
        return this.metricMap.get(metricName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(String metricsName, Long value) {
        MetricNotificationService metricNotificationService = this;
        synchronized (metricNotificationService) {
            this.createMetric(metricsName).setValue(value);
        }
    }

    private static class MetricGauge
    implements Gauge<Long> {
        private Long value = 0L;

        private MetricGauge() {
        }

        public void setValue(Long value) {
            this.value = value;
        }

        public Long getValue() {
            return this.value;
        }
    }
}

