/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.metadata;

import org.apache.falcon.entity.v0.EntityType;

public enum RelationshipType {
    CLUSTER_ENTITY("cluster-entity"),
    FEED_ENTITY("feed-entity"),
    PROCESS_ENTITY("process-entity"),
    DATASOURCE_ENTITY("datasource-entity"),
    FEED_INSTANCE("feed-instance"),
    PROCESS_INSTANCE("process-instance"),
    IMPORT_INSTANCE("import-instance"),
    USER("user"),
    COLO("data-center"),
    TAGS("classification"),
    GROUPS("group"),
    PIPELINES("pipelines"),
    REPLICATION_METRICS("replication-metrics");

    private final String name;

    private RelationshipType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static RelationshipType fromString(String value) {
        if (value != null) {
            for (RelationshipType type : RelationshipType.values()) {
                if (!value.equals(type.getName())) continue;
                return type;
            }
        }
        throw new IllegalArgumentException("No constant with value " + value + " found");
    }

    public static RelationshipType fromSchedulableEntityType(String type) {
        EntityType entityType = EntityType.getEnum(type);
        switch (entityType) {
            case FEED: {
                return FEED_ENTITY;
            }
            case PROCESS: {
                return PROCESS_ENTITY;
            }
        }
        throw new IllegalArgumentException("Invalid schedulable entity type: " + entityType.name());
    }
}

