/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.job;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.falcon.job.ReplicationJobCountersList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobCounters {
    private static final Logger LOG = LoggerFactory.getLogger(JobCounters.class);
    protected Map<String, Long> countersMap = new HashMap<String, Long>();

    public void obtainJobCounters(Configuration conf, Job job, boolean isDistCp) throws IOException {
        try {
            long timeTaken = job.getFinishTime() - job.getStartTime();
            this.countersMap.put(ReplicationJobCountersList.TIMETAKEN.getName(), timeTaken);
            Counters jobCounters = job.getCounters();
            this.parseJob(job, jobCounters, isDistCp);
        }
        catch (Exception e) {
            LOG.info("Exception occurred while obtaining job counters: {}", (Throwable)e);
        }
    }

    protected void populateReplicationCountersMap(Counters jobCounters) {
        for (CopyMapper.Counter copyCounterVal : CopyMapper.Counter.values()) {
            Counter counter;
            if (ReplicationJobCountersList.getCountersKey(copyCounterVal.name()) == null || (counter = jobCounters.findCounter((Enum)copyCounterVal)) == null) continue;
            String counterName = counter.getName();
            long counterValue = counter.getValue();
            this.countersMap.put(counterName, counterValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJobCounters(Configuration conf, Path counterFile) throws IOException {
        FileSystem sourceFs = FileSystem.get((Configuration)conf);
        FSDataOutputStream out = null;
        try {
            out = sourceFs.create(counterFile);
            for (Map.Entry<String, Long> counter : this.countersMap.entrySet()) {
                out.write((counter.getKey() + ":" + counter.getValue()).getBytes());
                out.write("\n".getBytes());
            }
            out.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public Map<String, Long> getCountersMap() {
        return this.countersMap;
    }

    protected abstract void parseJob(Job var1, Counters var2, boolean var3) throws IOException;
}

