/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.job;

import java.io.IOException;
import org.apache.falcon.job.JobCounters;
import org.apache.falcon.job.ReplicationJobCountersList;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveReplicationCounters
extends JobCounters {
    private static final Logger LOG = LoggerFactory.getLogger(HiveReplicationCounters.class);

    @Override
    protected void parseJob(Job job, Counters jobCounters, boolean isDistCp) throws IOException {
        if (isDistCp) {
            this.populateReplicationCountersMap(jobCounters);
        } else {
            this.populateCustomCountersMap(jobCounters);
        }
    }

    private void populateCustomCountersMap(Counters jobCounters) {
        for (ReplicationJobCountersList counterVal : ReplicationJobCountersList.values()) {
            Counter counter;
            if (counterVal == ReplicationJobCountersList.TIMETAKEN || (counter = jobCounters.findCounter((Enum)counterVal)) == null) continue;
            String counterName = counter.getName();
            long counterValue = counter.getValue();
            this.countersMap.put(counterName, counterValue);
        }
    }
}

