/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.v0;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.falcon.entity.v0.DateValidator;

public final class SchemaHelper {
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm'Z'";

    private SchemaHelper() {
    }

    public static String getTimeZoneId(TimeZone tz) {
        return tz.getID();
    }

    public static DateFormat getDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(ISO8601_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat;
    }

    public static String formatDateUTC(Date date) {
        return date != null ? SchemaHelper.getDateFormat().format(date) : null;
    }

    public static Date parseDateUTC(String dateStr) {
        if (!DateValidator.validate(dateStr)) {
            throw new IllegalArgumentException(dateStr + " is not a valid UTC string");
        }
        try {
            return SchemaHelper.getDateFormat().parse(dateStr);
        }
        catch (ParseException e) {
            throw new RuntimeException("Unable to parse date: " + dateStr, e);
        }
    }

    public static String formatDateUTCToISO8601(String dateString, String dateStringFormat) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateStringFormat.substring(0, dateString.length()));
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return SchemaHelper.formatDateUTC(dateFormat.parse(dateString));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

