/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.parser;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.DatasourceHelper;
import org.apache.falcon.entity.parser.EntityParser;
import org.apache.falcon.entity.parser.ValidationException;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.datasource.ACL;
import org.apache.falcon.entity.v0.datasource.Datasource;
import org.apache.falcon.entity.v0.datasource.Interfacetype;
import org.apache.falcon.util.HdfsClassLoader;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceEntityParser
extends EntityParser<Datasource> {
    private static final Logger LOG = LoggerFactory.getLogger(DatasourceEntityParser.class);

    public DatasourceEntityParser() {
        super(EntityType.DATASOURCE);
    }

    @Override
    public void validate(Datasource db) throws FalconException {
        try {
            ClassLoader hdfsClassLoader = HdfsClassLoader.load(db.getName(), db.getDriver().getJars());
            DatasourceEntityParser.validateInterface(db, Interfacetype.READONLY, hdfsClassLoader);
            DatasourceEntityParser.validateInterface(db, Interfacetype.WRITE, hdfsClassLoader);
            this.validateACL(db);
        }
        catch (IOException io) {
            throw new ValidationException("Unable to copy driver jars to local dir: " + Arrays.toString(db.getDriver().getJars().toArray()));
        }
    }

    private static void validateInterface(Datasource db, Interfacetype interfacetype, ClassLoader hdfsClassLoader) throws ValidationException {
        String endpoint = null;
        Properties userPasswdInfo = null;
        try {
            if (interfacetype == Interfacetype.READONLY) {
                endpoint = DatasourceHelper.getReadOnlyEndpoint(db);
                userPasswdInfo = DatasourceHelper.fetchReadPasswordInfo(db);
            } else if (interfacetype == Interfacetype.WRITE) {
                endpoint = DatasourceHelper.getWriteEndpoint(db);
                userPasswdInfo = DatasourceHelper.fetchWritePasswordInfo(db);
            }
            if (StringUtils.isNotBlank(endpoint)) {
                LOG.info("Validating {} endpoint {} connection.", (Object)interfacetype.value(), (Object)endpoint);
                DatasourceEntityParser.validateConnection(hdfsClassLoader, db.getDriver().getClazz(), endpoint, userPasswdInfo);
            }
        }
        catch (FalconException fe) {
            throw new ValidationException(String.format("Cannot validate '%s' interface '%s' of database entity '%s' due to '%s' ", new Object[]{interfacetype, endpoint, db.getName(), fe.getMessage()}));
        }
    }

    private static void validateConnection(ClassLoader hdfsClassLoader, String driverClass, String connectUrl, Properties userPasswdInfo) throws FalconException {
        ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
        LOG.info("Preserving current classloader: {}", (Object)previousClassLoader.toString());
        try {
            Thread.currentThread().setContextClassLoader(hdfsClassLoader);
            LOG.info("Setting context classloader to : {}", (Object)hdfsClassLoader.toString());
            Driver driver = (Driver)hdfsClassLoader.loadClass(driverClass).newInstance();
            LOG.info("Validating connection URL: {} using driver: {}", (Object)connectUrl, (Object)driver.getClass().toString());
            Connection con = driver.connect(connectUrl, userPasswdInfo);
            if (con == null) {
                throw new FalconException("DriverManager.getConnection() return null for URL : " + connectUrl);
            }
        }
        catch (Exception ex) {
            LOG.error("Exception while validating connection : ", (Throwable)ex);
            throw new FalconException(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousClassLoader);
            LOG.info("Restoring original classloader {}", (Object)previousClassLoader.toString());
        }
    }

    private void validateACL(Datasource db) throws ValidationException {
        if (this.isAuthorizationDisabled) {
            return;
        }
        ACL dbACL = db.getACL();
        if (dbACL == null) {
            throw new ValidationException("Datasource ACL cannot be empty for:  " + db.getName());
        }
        this.validateACLOwnerAndGroup(dbACL);
        try {
            this.authorize(db.getName(), dbACL);
        }
        catch (AuthorizationException e) {
            throw new ValidationException((Exception)((Object)e));
        }
    }
}

