/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.common;

import java.util.Calendar;
import java.util.regex.Pattern;

public final class FeedDataPath {
    public static final Pattern PATTERN = Pattern.compile(VARS.YEAR.regex() + "|" + VARS.MONTH.regex() + "|" + VARS.DAY.regex() + "|" + VARS.HOUR.regex() + "|" + VARS.MINUTE.regex());

    private FeedDataPath() {
    }

    public static enum VARS {
        YEAR("([0-9]{4})", 1, 4),
        MONTH("(0[1-9]|1[0-2])", 2, 2),
        DAY("(0[1-9]|1[0-9]|2[0-9]|3[0-1])", 5, 2),
        HOUR("([0-1][0-9]|2[0-4])", 11, 2),
        MINUTE("([0-5][0-9]|60)", 12, 2);

        private final Pattern pattern = Pattern.compile("\\$\\{" + this.name() + "\\}");
        private final String valuePattern;
        private final int calendarField;
        private final int valueSize;

        private VARS(String patternRegularExpression, int calField, int numDigits) {
            this.valuePattern = patternRegularExpression;
            this.calendarField = calField;
            this.valueSize = numDigits;
        }

        public String getValuePattern() {
            return this.valuePattern;
        }

        public String regex() {
            return this.pattern.pattern();
        }

        public int getCalendarField() {
            return this.calendarField;
        }

        public int getValueSize() {
            return this.valueSize;
        }

        public void setCalendar(Calendar cal, int value) {
            if (this == MONTH) {
                cal.set(this.calendarField, value - 1);
            } else {
                cal.set(this.calendarField, value);
            }
        }

        public static VARS from(String str) {
            for (VARS var : VARS.values()) {
                if (!var.pattern.matcher(str).matches()) continue;
                return var;
            }
            return null;
        }
    }
}

