/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.TrustManagerUtils;
import org.apache.falcon.LifeCycle;
import org.apache.falcon.client.AbstractFalconClient;
import org.apache.falcon.client.FalconCLIException;
import org.apache.falcon.entity.v0.DateValidator;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.metadata.RelationshipType;
import org.apache.falcon.resource.APIResult;
import org.apache.falcon.resource.EntityList;
import org.apache.falcon.resource.EntitySummaryResult;
import org.apache.falcon.resource.ExtensionInstanceList;
import org.apache.falcon.resource.ExtensionJobList;
import org.apache.falcon.resource.FeedInstanceResult;
import org.apache.falcon.resource.FeedLookupResult;
import org.apache.falcon.resource.InstanceDependencyResult;
import org.apache.falcon.resource.InstancesResult;
import org.apache.falcon.resource.InstancesSummaryResult;
import org.apache.falcon.resource.LineageGraphResult;
import org.apache.falcon.resource.SchedulableEntityInstanceResult;
import org.apache.falcon.resource.TriageResult;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;

public class FalconClient
extends AbstractFalconClient {
    public static final AtomicReference<PrintStream> OUT = new AtomicReference<PrintStream>(System.out);
    public static final String WS_HEADER_PREFIX = "header:";
    public static final String USER = System.getProperty("user.name");
    public static final String AUTH_URL = "api/options?user.name=" + USER;
    public static final String PATH = "path";
    public static final String COLO = "colo";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    public static final String CLUSTER = "cluster";
    public static final String RUN_ID = "runid";
    public static final String FORCE = "force";
    public static final String SHOW_SCHEDULER = "showScheduler";
    public static final String ENTITY_NAME = "name";
    public static final String ENTITY_TYPE = "type";
    public static final String SKIP_DRYRUN = "skipDryRun";
    public static final String FILTER_BY = "filterBy";
    public static final String ORDER_BY = "orderBy";
    public static final String SORT_ORDER = "sortOrder";
    public static final String OFFSET = "offset";
    public static final String NUM_RESULTS = "numResults";
    public static final String START = "start";
    public static final String END = "end";
    public static final String INSTANCE_TIME = "instanceTime";
    public static final String INSTANCE_STATUS = "instanceStatus";
    public static final String PROPERTIES = "properties";
    private static final String FIELDS = "fields";
    private static final String NAME_SUBSEQUENCE = "nameseq";
    private static final String FILTER_TAGS = "tags";
    private static final String TAG_KEYWORDS = "tagkeys";
    private static final String LIFECYCLE = "lifecycle";
    private static final String NUM_INSTANCES = "numInstances";
    public static final String ALL_ATTEMPTS = "allAttempts";
    public static final String DO_AS_OPT = "doAs";
    public static final String AUTH_COOKIE = "hadoop.auth";
    private static final String AUTH_COOKIE_EQ = "hadoop.auth=";
    private static final KerberosAuthenticator AUTHENTICATOR = new KerberosAuthenticator();
    private static final String TEMPLATE_SUFFIX = "-template.xml";
    private static final String PROPERTIES_SUFFIX = ".properties";
    public static final HostnameVerifier ALL_TRUSTING_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession sslSession) {
            return true;
        }
    };
    private final WebResource service;
    private final AuthenticatedURL.Token authenticationToken;
    private boolean debugMode = false;
    private final Properties clientProperties;

    public FalconClient(String falconUrl) throws FalconCLIException {
        this(falconUrl, new Properties());
    }

    public FalconClient(String falconUrl, Properties properties) throws FalconCLIException {
        try {
            String baseUrl = this.notEmpty(falconUrl, "FalconUrl");
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            this.clientProperties = properties;
            SSLContext sslContext = FalconClient.getSslContext();
            DefaultClientConfig config = new DefaultClientConfig();
            config.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(ALL_TRUSTING_HOSTNAME_VERIFIER, sslContext));
            Client client = Client.create(config);
            client.setConnectTimeout(Integer.parseInt(this.clientProperties.getProperty("falcon.connect.timeout", "180000")));
            client.setReadTimeout(Integer.parseInt(this.clientProperties.getProperty("falcon.read.timeout", "180000")));
            this.service = client.resource(UriBuilder.fromUri(baseUrl).build(new Object[0]));
            client.resource(UriBuilder.fromUri(baseUrl).build(new Object[0]));
            this.authenticationToken = FalconClient.getToken(baseUrl);
        }
        catch (Exception e) {
            throw new FalconCLIException("Unable to initialize Falcon Client object. Cause : " + e.getMessage(), e);
        }
    }

    private static SSLContext getSslContext() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{TrustManagerUtils.getValidateServerCertificateTrustManager()}, new SecureRandom());
        return sslContext;
    }

    public boolean getDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public static AuthenticatedURL.Token getToken(String baseUrl) throws FalconCLIException {
        AuthenticatedURL.Token currentToken = new AuthenticatedURL.Token();
        try {
            URL url = new URL(baseUrl + AUTH_URL);
            HttpsURLConnection.setDefaultSSLSocketFactory(FalconClient.getSslContext().getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(ALL_TRUSTING_HOSTNAME_VERIFIER);
            new AuthenticatedURL((Authenticator)AUTHENTICATOR).openConnection(url, currentToken);
        }
        catch (Exception ex) {
            throw new FalconCLIException("Could not authenticate, " + ex.getMessage(), ex);
        }
        return currentToken;
    }

    public String notEmpty(String str, String name) {
        if (str == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        if (str.length() == 0) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
        return str;
    }

    @Override
    public APIResult schedule(EntityType entityType, String entityName, String colo, Boolean skipDryRun, String doAsUser, String properties) throws FalconCLIException {
        String type = entityType.toString().toLowerCase();
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.SCHEDULE.path, type, entityName}).addQueryParam(COLO, colo).addQueryParam(SKIP_DRYRUN, skipDryRun).addQueryParam(PROPERTIES, properties).addQueryParam(DO_AS_OPT, doAsUser).call(Entities.SCHEDULE);
        return this.getResponse(APIResult.class, clientResponse);
    }

    @Override
    public APIResult suspend(EntityType entityType, String entityName, String colo, String doAsUser) throws FalconCLIException {
        String type = entityType.toString().toLowerCase();
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.SUSPEND.path, type, entityName}).addQueryParam(COLO, colo).addQueryParam(DO_AS_OPT, doAsUser).call(Entities.SUSPEND);
        return this.getResponse(APIResult.class, clientResponse);
    }

    @Override
    public APIResult resume(EntityType entityType, String entityName, String colo, String doAsUser) throws FalconCLIException {
        String type = entityType.toString().toLowerCase();
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.RESUME.path, type, entityName}).addQueryParam(COLO, colo).addQueryParam(DO_AS_OPT, doAsUser).call(Entities.RESUME);
        return this.getResponse(APIResult.class, clientResponse);
    }

    @Override
    public APIResult delete(EntityType entityType, String entityName, String doAsUser) throws FalconCLIException {
        String type = entityType.toString().toLowerCase();
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.DELETE.path, type, entityName}).addQueryParam(DO_AS_OPT, doAsUser).call(Entities.DELETE);
        return this.getResponse(APIResult.class, clientResponse);
    }

    @Override
    public APIResult validate(String entityType, String filePath, Boolean skipDryRun, String doAsUser) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.VALIDATE.path, entityType}).addQueryParam(SKIP_DRYRUN, skipDryRun).addQueryParam(DO_AS_OPT, doAsUser).call(Entities.VALIDATE, entityStream);
        return this.getResponse(APIResult.class, clientResponse);
    }

    @Override
    public APIResult submit(String entityType, String filePath, String doAsUser) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.SUBMIT.path, entityType}).addQueryParam(DO_AS_OPT, doAsUser).call(Entities.SUBMIT, entityStream);
        return this.getResponse(APIResult.class, clientResponse);
    }

    @Override
    public APIResult update(String entityType, String entityName, String filePath, Boolean skipDryRun, String doAsUser) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        Entities operation = Entities.UPDATE;
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{operation.path, entityType, entityName}).addQueryParam(SKIP_DRYRUN, skipDryRun).addQueryParam(DO_AS_OPT, doAsUser).call(operation, entityStream);
        return this.getResponse(APIResult.class, clientResponse);
    }

    public APIResult updateClusterDependents(String clusterName, Boolean skipDryRun, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.UPDATEDEPENDENTS.path, clusterName}).addQueryParam(SKIP_DRYRUN, skipDryRun).addQueryParam(DO_AS_OPT, doAsUser).call(Entities.UPDATEDEPENDENTS);
        return this.getResponse(APIResult.class, clientResponse);
    }

    @Override
    public APIResult submitAndSchedule(String entityType, String filePath, Boolean skipDryRun, String doAsUser, String properties) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.SUBMITANDSCHEDULE.path, entityType}).addQueryParam(SKIP_DRYRUN, skipDryRun).addQueryParam(DO_AS_OPT, doAsUser).addQueryParam(PROPERTIES, properties).call(Entities.SUBMITANDSCHEDULE, entityStream);
        return this.getResponse(APIResult.class, clientResponse);
    }

    @Override
    public APIResult getStatus(EntityType entityType, String entityName, String colo, String doAsUser, boolean showScheduler) throws FalconCLIException {
        String type = entityType.toString().toLowerCase();
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.STATUS.path, type, entityName}).addQueryParam(COLO, colo).addQueryParam(DO_AS_OPT, doAsUser).addQueryParam(SHOW_SCHEDULER, showScheduler).call(Entities.STATUS);
        return this.getResponse(APIResult.class, clientResponse);
    }

    @Override
    public Entity getDefinition(String entityType, String entityName, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.DEFINITION.path, entityType, entityName}).call(Entities.DEFINITION);
        String entity = this.getResponseAsString(clientResponse);
        return Entity.fromString(EntityType.getEnum(entityType), entity);
    }

    public EntityList getDependency(String entityType, String entityName, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.DEPENDENCY.path, entityType, entityName}).addQueryParam(DO_AS_OPT, doAsUser).call(Entities.DEPENDENCY);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        EntityList result = clientResponse.getEntity(EntityList.class);
        if (result == null || result.getElements() == null) {
            return new EntityList();
        }
        return result;
    }

    public SchedulableEntityInstanceResult getFeedSlaMissPendingAlerts(String entityType, String entityName, String startTime, String endTime, String colo) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.SLA.path, entityType}).addQueryParam(START, startTime).addQueryParam(COLO, colo).addQueryParam(END, endTime).addQueryParam(ENTITY_NAME, entityName).call(Entities.SLA);
        return this.getResponse(SchedulableEntityInstanceResult.class, clientResponse);
    }

    public TriageResult triage(String entityType, String entityName, String instanceTime, String colo) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.TRIAGE.path, entityType, entityName}).addQueryParam(START, instanceTime).addQueryParam(COLO, colo).call(Instances.TRIAGE);
        return this.getResponse(TriageResult.class, clientResponse);
    }

    @Override
    public EntityList getEntityList(String entityType, String fields, String nameSubsequence, String tagKeywords, String filterBy, String filterTags, String orderBy, String sortOrder, Integer offset, Integer numResults, String doAsUser) throws FalconCLIException {
        Entities operation = Entities.LIST;
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{operation.path, entityType}).addQueryParam(DO_AS_OPT, doAsUser).addQueryParam(NUM_RESULTS, numResults).addQueryParam(OFFSET, offset).addQueryParam(SORT_ORDER, sortOrder).addQueryParam(ORDER_BY, orderBy).addQueryParam(FILTER_BY, filterBy).addQueryParam(FIELDS, fields).addQueryParam(NAME_SUBSEQUENCE, nameSubsequence).addQueryParam(TAG_KEYWORDS, tagKeywords).addQueryParam(FILTER_TAGS, filterTags).call(operation);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        EntityList result = clientResponse.getEntity(EntityList.class);
        if (result == null || result.getElements() == null) {
            return null;
        }
        return result;
    }

    @Override
    public EntitySummaryResult getEntitySummary(String entityType, String cluster, String start, String end, String fields, String filterBy, String filterTags, String orderBy, String sortOrder, Integer offset, Integer numResults, Integer numInstances, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Entities.SUMMARY.path, entityType}).addQueryParam(CLUSTER, cluster).addQueryParam(START, start).addQueryParam(END, end).addQueryParam(SORT_ORDER, sortOrder).addQueryParam(ORDER_BY, orderBy).addQueryParam(OFFSET, offset).addQueryParam(NUM_RESULTS, numResults).addQueryParam(DO_AS_OPT, doAsUser).addQueryParam(FILTER_BY, filterBy).addQueryParam(NUM_INSTANCES, numInstances).addQueryParam(FIELDS, fields).addQueryParam(FILTER_TAGS, filterTags).call(Entities.SUMMARY);
        return this.getResponse(EntitySummaryResult.class, clientResponse);
    }

    @Override
    public APIResult touch(String entityType, String entityName, String colo, Boolean skipDryRun, String doAsUser) throws FalconCLIException {
        Entities operation = Entities.TOUCH;
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{operation.path, entityType, entityName}).addQueryParam(COLO, colo).addQueryParam(SKIP_DRYRUN, skipDryRun).addQueryParam(DO_AS_OPT, doAsUser).call(operation);
        return this.getResponse(APIResult.class, clientResponse);
    }

    public InstancesResult getRunningInstances(String type, String entity, String colo, List<LifeCycle> lifeCycles, String filterBy, String orderBy, String sortOrder, Integer offset, Integer numResults, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.RUNNING.path, type, entity}).addQueryParam(FILTER_BY, filterBy).addQueryParam(ORDER_BY, orderBy).addQueryParam(SORT_ORDER, sortOrder).addQueryParam(OFFSET, offset).addQueryParam(NUM_RESULTS, numResults).addQueryParam(COLO, colo).addQueryParam(LIFECYCLE, lifeCycles, type).addQueryParam(USER, doAsUser).call(Instances.RUNNING);
        return this.getResponse(InstancesResult.class, clientResponse);
    }

    @Override
    public InstancesResult getStatusOfInstances(String type, String entity, String start, String end, String colo, List<LifeCycle> lifeCycles, String filterBy, String orderBy, String sortOrder, Integer offset, Integer numResults, String doAsUser, Boolean allAttempts) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.STATUS.path, type, entity}).addQueryParam(START, start).addQueryParam(END, end).addQueryParam(COLO, colo).addQueryParam(LIFECYCLE, lifeCycles, type).addQueryParam(FILTER_BY, filterBy).addQueryParam(ORDER_BY, orderBy).addQueryParam(SORT_ORDER, sortOrder).addQueryParam(OFFSET, offset).addQueryParam(NUM_RESULTS, numResults).addQueryParam(ALL_ATTEMPTS, allAttempts).addQueryParam(USER, doAsUser).call(Instances.STATUS);
        return this.getResponse(InstancesResult.class, clientResponse);
    }

    @Override
    public InstancesSummaryResult getSummaryOfInstances(String type, String entity, String start, String end, String colo, List<LifeCycle> lifeCycles, String filterBy, String orderBy, String sortOrder, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.SUMMARY.path, type, entity}).addQueryParam(START, start).addQueryParam(END, end).addQueryParam(COLO, colo).addQueryParam(LIFECYCLE, lifeCycles, type).addQueryParam(USER, doAsUser).call(Instances.SUMMARY);
        return this.getResponse(InstancesSummaryResult.class, clientResponse);
    }

    @Override
    public FeedInstanceResult getFeedListing(String type, String entity, String start, String end, String colo, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.KILL.path, type, entity}).addQueryParam(START, start).addQueryParam(END, end).addQueryParam(COLO, colo).addQueryParam(USER, doAsUser).call(Instances.LISTING);
        return this.getResponse(FeedInstanceResult.class, clientResponse);
    }

    public InstancesResult searchInstances(String type, String nameSubsequence, String tagKeywords, String start, String end, String status, String orderBy, Integer offset, Integer numResults) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.SEARCH.path}).addQueryParam(ENTITY_TYPE, type).addQueryParam(NAME_SUBSEQUENCE, nameSubsequence).addQueryParam(TAG_KEYWORDS, tagKeywords).addQueryParam(START, start).addQueryParam(END, end).addQueryParam(INSTANCE_STATUS, status).addQueryParam(ORDER_BY, orderBy).addQueryParam(OFFSET, offset).addQueryParam(NUM_RESULTS, numResults).call(Instances.SEARCH);
        return this.getResponse(InstancesResult.class, clientResponse);
    }

    @Override
    public InstancesResult killInstances(String type, String entity, String start, String end, String colo, String clusters, String sourceClusters, List<LifeCycle> lifeCycles, String doAsUser) throws FalconCLIException, UnsupportedEncodingException {
        InputStream props = this.getServletInputStream(clusters, sourceClusters, null);
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.KILL.path, type, entity}).addQueryParam(START, start).addQueryParam(END, end).addQueryParam(COLO, colo).addQueryParam(LIFECYCLE, lifeCycles, type).addQueryParam(USER, doAsUser).call(Instances.KILL, props);
        return this.getResponse(InstancesResult.class, clientResponse);
    }

    @Override
    public InstancesResult suspendInstances(String type, String entity, String start, String end, String colo, String clusters, String sourceClusters, List<LifeCycle> lifeCycles, String doAsUser) throws FalconCLIException, UnsupportedEncodingException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.SUSPEND.path, type, entity}).addQueryParam(START, start).addQueryParam(END, end).addQueryParam(COLO, colo).addQueryParam(LIFECYCLE, lifeCycles, type).addQueryParam(USER, doAsUser).call(Instances.SUSPEND);
        return this.getResponse(InstancesResult.class, clientResponse);
    }

    @Override
    public InstancesResult resumeInstances(String type, String entity, String start, String end, String colo, String clusters, String sourceClusters, List<LifeCycle> lifeCycles, String doAsUser) throws FalconCLIException, UnsupportedEncodingException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.RESUME.path, type, entity}).addQueryParam(START, start).addQueryParam(END, end).addQueryParam(COLO, colo).addQueryParam(LIFECYCLE, lifeCycles, type).addQueryParam(USER, doAsUser).call(Instances.RESUME);
        return this.getResponse(InstancesResult.class, clientResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstancesResult rerunInstances(String type, String entity, String start, String end, String filePath, String colo, String clusters, String sourceClusters, List<LifeCycle> lifeCycles, Boolean isForced, String doAsUser) throws FalconCLIException, IOException {
        StringBuilder buffer = new StringBuilder();
        if (filePath != null) {
            BufferedReader in = null;
            try {
                String str;
                in = new BufferedReader(new FileReader(filePath));
                while ((str = in.readLine()) != null) {
                    buffer.append(str).append("\n");
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
        }
        String temp = buffer.length() == 0 ? null : buffer.toString();
        InputStream props = this.getServletInputStream(clusters, sourceClusters, temp);
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.RERUN.path, type, entity}).addQueryParam(START, start).addQueryParam(END, end).addQueryParam(COLO, colo).addQueryParam(LIFECYCLE, lifeCycles, type).addQueryParam(FORCE, isForced).addQueryParam(USER, doAsUser).call(Instances.RERUN, props);
        return this.getResponse(InstancesResult.class, clientResponse);
    }

    @Override
    public InstancesResult getLogsOfInstances(String type, String entity, String start, String end, String colo, String runId, List<LifeCycle> lifeCycles, String filterBy, String orderBy, String sortOrder, Integer offset, Integer numResults, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.LOG.path, type, entity}).addQueryParam(START, start).addQueryParam(END, end).addQueryParam(COLO, colo).addQueryParam(RUN_ID, runId).addQueryParam(LIFECYCLE, lifeCycles, type).addQueryParam(FILTER_BY, filterBy).addQueryParam(ORDER_BY, orderBy).addQueryParam(SORT_ORDER, sortOrder).addQueryParam(OFFSET, offset).addQueryParam(NUM_RESULTS, numResults).addQueryParam(USER, doAsUser).call(Instances.LOG);
        return this.getResponse(InstancesResult.class, clientResponse);
    }

    @Override
    public InstancesResult getParamsOfInstance(String type, String entity, String start, String colo, List<LifeCycle> lifeCycles, String doAsUser) throws FalconCLIException, UnsupportedEncodingException {
        if (!DateValidator.validate(start)) {
            throw new FalconCLIException("Start date is mandatory and should be a valid date in  YYYY-MM-DDTHH:MMZ format.");
        }
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{Instances.PARAMS.path, type, entity}).addQueryParam(START, start).addQueryParam(LIFECYCLE, lifeCycles, type).addQueryParam(USER, doAsUser).call(Instances.PARAMS);
        return this.getResponse(InstancesResult.class, clientResponse);
    }

    public String getThreadDump(String doAsUser) throws FalconCLIException {
        return this.sendAdminRequest(AdminOperations.STACK, doAsUser);
    }

    @Override
    public String getVersion(String doAsUser) throws FalconCLIException {
        return this.sendAdminRequest(AdminOperations.VERSION, doAsUser);
    }

    public int getStatus(String doAsUser) throws FalconCLIException {
        AdminOperations job = AdminOperations.VERSION;
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{job.path}).addQueryParam(DO_AS_OPT, doAsUser).call(job);
        this.printClientResponse(clientResponse);
        return clientResponse.getStatus();
    }

    public ClientResponse setSafemode(String safemode, String doAsUser) throws FalconCLIException {
        AdminOperations job = AdminOperations.SAFEMODE;
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{job.path}).path(new String[]{safemode}).addQueryParam(DO_AS_OPT, doAsUser).call(job);
        this.printClientResponse(clientResponse);
        return clientResponse;
    }

    public String getDimensionList(String dimensionType, String cluster, String doAsUser) throws FalconCLIException {
        return this.sendMetadataDiscoveryRequest(MetadataOperations.LIST, dimensionType, null, cluster, doAsUser);
    }

    public String getReplicationMetricsDimensionList(String schedEntityType, String schedEntityName, Integer numResults, String doAsUser) throws FalconCLIException {
        return this.sendRequestForReplicationMetrics(MetadataOperations.LIST, schedEntityType, schedEntityName, numResults, doAsUser);
    }

    public LineageGraphResult getEntityLineageGraph(String pipelineName, String doAsUser) throws FalconCLIException {
        MetadataOperations operation = MetadataOperations.LINEAGE;
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{operation.path}).addQueryParam(DO_AS_OPT, doAsUser).addQueryParam("pipeline", pipelineName).call(operation);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return clientResponse.getEntity(LineageGraphResult.class);
    }

    public String getDimensionRelations(String dimensionType, String dimensionName, String doAsUser) throws FalconCLIException {
        return this.sendMetadataDiscoveryRequest(MetadataOperations.RELATIONS, dimensionType, dimensionName, null, doAsUser);
    }

    private InputStream getServletInputStream(String filePath) throws FalconCLIException {
        FileInputStream stream;
        if (filePath == null) {
            return null;
        }
        try {
            stream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new FalconCLIException("File not found:", e);
        }
        return stream;
    }

    private <T> T getResponse(Class<T> clazz, ClientResponse clientResponse) throws FalconCLIException {
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return clientResponse.getEntity(clazz);
    }

    private String getResponseAsString(ClientResponse clientResponse) throws FalconCLIException {
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return clientResponse.getEntity(String.class);
    }

    public FeedLookupResult reverseLookUp(String type, String path, String doAsUser) throws FalconCLIException {
        Entities api = Entities.LOOKUP;
        ClientResponse response = new ResourceBuilder().path(new String[]{api.path, type}).addQueryParam(DO_AS_OPT, doAsUser).addQueryParam(PATH, path).call(api);
        return this.getResponse(FeedLookupResult.class, response);
    }

    public FeedInstanceResult getFeedInstanceListing(String type, String entity, String start, String end, String colo, String doAsUser) throws FalconCLIException {
        this.checkType(type);
        Instances api = Instances.LISTING;
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{api.path, type, entity}).addQueryParam(COLO, colo).addQueryParam(DO_AS_OPT, doAsUser).addQueryParam(START, start).addQueryParam(END, end).call(api);
        return this.getResponse(FeedInstanceResult.class, clientResponse);
    }

    @Override
    public InstanceDependencyResult getInstanceDependencies(String entityType, String entityName, String instanceTime, String colo) throws FalconCLIException {
        this.checkType(entityType);
        Instances api = Instances.DEPENDENCY;
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{api.path, entityType, entityName}).addQueryParam(COLO, colo).addQueryParam(INSTANCE_TIME, instanceTime).call(api);
        return this.getResponse(InstanceDependencyResult.class, clientResponse);
    }

    private void checkLifeCycleOption(List<LifeCycle> lifeCycles, String type) throws FalconCLIException {
        if (lifeCycles != null && !lifeCycles.isEmpty()) {
            EntityType entityType = EntityType.getEnum(type);
            for (LifeCycle lifeCycle : lifeCycles) {
                if (entityType == lifeCycle.getTag().getType()) continue;
                throw new FalconCLIException("Incorrect lifecycle: " + (Object)((Object)lifeCycle) + "for given type: " + type);
            }
        }
    }

    protected void checkType(String type) throws FalconCLIException {
        if (type == null || type.isEmpty()) {
            throw new FalconCLIException("entity type is empty");
        }
        EntityType entityType = EntityType.getEnum(type);
        if (entityType == EntityType.CLUSTER) {
            throw new FalconCLIException("Instance management functions don't apply to Cluster entities");
        }
    }

    private String sendAdminRequest(AdminOperations job, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{job.path}).addQueryParam(DO_AS_OPT, doAsUser).call(job);
        return this.getResponseAsString(clientResponse);
    }

    private String sendRequestForReplicationMetrics(MetadataOperations operation, String schedEntityType, String schedEntityName, Integer numResults, String doAsUser) throws FalconCLIException {
        WebResource resource = this.service.path(operation.path).path(schedEntityName).path(RelationshipType.REPLICATION_METRICS.getName()).path("list");
        if (StringUtils.isNotEmpty(schedEntityName)) {
            resource = resource.queryParam(ENTITY_TYPE, schedEntityType);
        }
        if (numResults != null) {
            resource = resource.queryParam(NUM_RESULTS, numResults.toString());
        }
        if (StringUtils.isNotEmpty(doAsUser)) {
            resource = resource.queryParam(DO_AS_OPT, doAsUser);
        }
        ClientResponse clientResponse = ((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", AUTH_COOKIE_EQ + this.authenticationToken).accept(operation.mimeType)).type(operation.mimeType)).method(operation.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return clientResponse.getEntity(String.class);
    }

    private String sendMetadataDiscoveryRequest(MetadataOperations operation, String dimensionType, String dimensionName, String cluster, String doAsUser) throws FalconCLIException {
        WebResource resource;
        switch (operation) {
            case LIST: {
                resource = this.service.path(operation.path).path(dimensionType).path("list");
                break;
            }
            case RELATIONS: {
                resource = this.service.path(operation.path).path(dimensionType).path(dimensionName).path("relations");
                break;
            }
            default: {
                throw new FalconCLIException("Invalid Metadata client Operation " + operation.toString());
            }
        }
        if (!StringUtils.isEmpty(cluster)) {
            resource = resource.queryParam(CLUSTER, cluster);
        }
        if (StringUtils.isNotEmpty(doAsUser)) {
            resource = resource.queryParam(DO_AS_OPT, doAsUser);
        }
        ClientResponse clientResponse = ((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", AUTH_COOKIE_EQ + this.authenticationToken).accept(operation.mimeType)).type(operation.mimeType)).method(operation.method, ClientResponse.class);
        this.printClientResponse(clientResponse);
        this.checkIfSuccessful(clientResponse);
        return clientResponse.getEntity(String.class);
    }

    public String getVertex(String id, String doAsUser) throws FalconCLIException {
        return this.sendMetadataLineageRequest(MetadataOperations.VERTICES, id, doAsUser);
    }

    public String getVertices(String key, String value, String doAsUser) throws FalconCLIException {
        return this.sendMetadataLineageRequest(MetadataOperations.VERTICES, key, value, doAsUser);
    }

    public String getVertexEdges(String id, String direction, String doAsUser) throws FalconCLIException {
        return this.sendMetadataLineageRequestForEdges(MetadataOperations.VERTICES, id, direction, doAsUser);
    }

    public String getEdge(String id, String doAsUser) throws FalconCLIException {
        return this.sendMetadataLineageRequest(MetadataOperations.EDGES, id, doAsUser);
    }

    public String enumerateExtensions() throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.ENUMERATE.path}).call(ExtensionOperations.ENUMERATE);
        return this.getResponse(String.class, clientResponse);
    }

    public String getExtensionDefinition(String extensionName) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.DEFINITION.path, extensionName}).call(ExtensionOperations.DEFINITION);
        return this.getResponse(String.class, clientResponse);
    }

    public String getExtensionDescription(String extensionName) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.DESCRIBE.path, extensionName}).call(ExtensionOperations.DESCRIBE);
        return this.getResponse(String.class, clientResponse);
    }

    public APIResult submitExtensionJob(String extensionName, String filePath, String doAsUser) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.SUBMIT.path, extensionName}).addQueryParam(DO_AS_OPT, doAsUser).call(ExtensionOperations.SUBMIT, entityStream);
        return this.getResponse(APIResult.class, clientResponse);
    }

    public APIResult submitAndScheduleExtensionJob(String extensionName, String filePath, String doAsUser) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.SUBMIT_AND_SCHEDULE.path, extensionName}).addQueryParam(DO_AS_OPT, doAsUser).call(ExtensionOperations.SUBMIT_AND_SCHEDULE, entityStream);
        return this.getResponse(APIResult.class, clientResponse);
    }

    public APIResult updateExtensionJob(String extensionName, String filePath, String doAsUser) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.UPDATE.path, extensionName}).addQueryParam(DO_AS_OPT, doAsUser).call(ExtensionOperations.UPDATE, entityStream);
        return this.getResponse(APIResult.class, clientResponse);
    }

    public APIResult validateExtensionJob(String extensionName, String filePath, String doAsUser) throws FalconCLIException {
        InputStream entityStream = this.getServletInputStream(filePath);
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.VALIDATE.path, extensionName}).addQueryParam(DO_AS_OPT, doAsUser).call(ExtensionOperations.VALIDATE, entityStream);
        return this.getResponse(APIResult.class, clientResponse);
    }

    public APIResult scheduleExtensionJob(String jobName, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.SCHEDULE.path, jobName}).addQueryParam(DO_AS_OPT, doAsUser).call(ExtensionOperations.SCHEDULE);
        return this.getResponse(APIResult.class, clientResponse);
    }

    public APIResult suspendExtensionJob(String jobName, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.SUSPEND.path, jobName}).addQueryParam(DO_AS_OPT, doAsUser).call(ExtensionOperations.SUSPEND);
        return this.getResponse(APIResult.class, clientResponse);
    }

    public APIResult resumeExtensionJob(String jobName, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.RESUME.path, jobName}).addQueryParam(DO_AS_OPT, doAsUser).call(ExtensionOperations.RESUME);
        return this.getResponse(APIResult.class, clientResponse);
    }

    public APIResult deleteExtensionJob(String jobName, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.DELETE.path, jobName}).addQueryParam(DO_AS_OPT, doAsUser).call(ExtensionOperations.DELETE);
        return this.getResponse(APIResult.class, clientResponse);
    }

    public ExtensionJobList listExtensionJob(String extensionName, String doAsUser, String sortOrder, String offset, String numResults, String fields) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.LIST.path, extensionName}).addQueryParam(DO_AS_OPT, doAsUser).addQueryParam(FIELDS, fields).addQueryParam(SORT_ORDER, sortOrder).addQueryParam(OFFSET, offset).addQueryParam(NUM_RESULTS, numResults).call(ExtensionOperations.LIST);
        return this.getResponse(ExtensionJobList.class, clientResponse);
    }

    public ExtensionInstanceList listExtensionInstance(String jobName, String doAsUser, String fields, String start, String end, String status, String orderBy, String sortOrder, String offset, String numResults) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{ExtensionOperations.INSTANCES.path, jobName}).addQueryParam(DO_AS_OPT, doAsUser).addQueryParam(FIELDS, fields).addQueryParam(START, start).addQueryParam(END, end).addQueryParam(INSTANCE_STATUS, status).addQueryParam(ORDER_BY, orderBy).addQueryParam(SORT_ORDER, sortOrder).addQueryParam(OFFSET, offset).addQueryParam(NUM_RESULTS, numResults).call(ExtensionOperations.INSTANCES);
        return this.getResponse(ExtensionInstanceList.class, clientResponse);
    }

    private String sendExtensionRequest(ExtensionOperations operation, String extensionName) throws FalconCLIException {
        WebResource resource;
        switch (operation) {
            case ENUMERATE: {
                resource = this.service.path(operation.path);
                break;
            }
            case DESCRIBE: 
            case DEFINITION: {
                resource = this.service.path(operation.path).path(extensionName);
                break;
            }
            default: {
                throw new FalconCLIException("Invalid extension client Operation " + operation.toString());
            }
        }
        ClientResponse clientResponse = ((WebResource.Builder)((WebResource.Builder)resource.header("Cookie", AUTH_COOKIE_EQ + this.authenticationToken).accept(operation.mimeType)).type(operation.mimeType)).method(operation.method, ClientResponse.class);
        this.checkIfSuccessful(clientResponse);
        return clientResponse.getEntity(String.class);
    }

    private String sendMetadataLineageRequest(MetadataOperations job, String id, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{job.path, id}).addQueryParam(DO_AS_OPT, doAsUser).call(job);
        return this.getResponseAsString(clientResponse);
    }

    private String sendMetadataLineageRequest(MetadataOperations job, String key, String value, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{job.path}).addQueryParam(DO_AS_OPT, doAsUser).addQueryParam(KEY, key).addQueryParam(VALUE, value).call(job);
        return this.getResponseAsString(clientResponse);
    }

    private String sendMetadataLineageRequestForEdges(MetadataOperations job, String id, String direction, String doAsUser) throws FalconCLIException {
        ClientResponse clientResponse = new ResourceBuilder().path(new String[]{job.path, id, direction}).addQueryParam(DO_AS_OPT, doAsUser).call(job);
        return this.getResponseAsString(clientResponse);
    }

    private void checkIfSuccessful(ClientResponse clientResponse) throws FalconCLIException {
        Response.Status.Family statusFamily = clientResponse.getClientResponseStatus().getFamily();
        if (statusFamily != Response.Status.Family.SUCCESSFUL && statusFamily != Response.Status.Family.INFORMATIONAL) {
            throw FalconCLIException.fromReponse(clientResponse);
        }
    }

    private void printClientResponse(ClientResponse clientResponse) {
        if (this.getDebugMode()) {
            OUT.get().println(clientResponse.toString());
        }
    }

    private class ResourceBuilder {
        WebResource resource;

        private ResourceBuilder() {
        }

        private ResourceBuilder path(String ... paths) {
            for (String path : paths) {
                this.resource = this.resource == null ? FalconClient.this.service.path(path) : this.resource.path(path);
            }
            return this;
        }

        public ResourceBuilder addQueryParam(String paramName, Integer value) {
            if (value != null) {
                this.resource = this.resource.queryParam(paramName, value.toString());
            }
            return this;
        }

        public ResourceBuilder addQueryParam(String paramName, Boolean paramValue) {
            if (paramValue != null) {
                this.resource = this.resource.queryParam(paramName, String.valueOf(paramValue));
            }
            return this;
        }

        public ResourceBuilder addQueryParam(String paramName, String paramValue) {
            if (StringUtils.isNotBlank(paramValue)) {
                this.resource = this.resource.queryParam(paramName, paramValue);
            }
            return this;
        }

        public ResourceBuilder addQueryParam(String paramName, List<LifeCycle> lifeCycles, String type) throws FalconCLIException {
            if (lifeCycles != null) {
                FalconClient.this.checkLifeCycleOption(lifeCycles, type);
                for (LifeCycle lifeCycle : lifeCycles) {
                    this.resource = this.resource.queryParam(paramName, lifeCycle.toString());
                }
            }
            return this;
        }

        private ClientResponse call(Entities entities) {
            return ((WebResource.Builder)((WebResource.Builder)this.resource.header("Cookie", FalconClient.AUTH_COOKIE_EQ + FalconClient.this.authenticationToken).accept(entities.mimeType)).type("text/xml")).method(entities.method, ClientResponse.class);
        }

        public ClientResponse call(AdminOperations operation) {
            return ((WebResource.Builder)((WebResource.Builder)this.resource.header("Cookie", FalconClient.AUTH_COOKIE_EQ + FalconClient.this.authenticationToken).accept(operation.mimeType)).type("text/xml")).method(operation.method, ClientResponse.class);
        }

        private ClientResponse call(MetadataOperations metadataOperations) {
            return ((WebResource.Builder)((WebResource.Builder)this.resource.header("Cookie", FalconClient.AUTH_COOKIE_EQ + FalconClient.this.authenticationToken).accept(metadataOperations.mimeType)).type("text/xml")).method(metadataOperations.method, ClientResponse.class);
        }

        public ClientResponse call(Instances operation) {
            return ((WebResource.Builder)((WebResource.Builder)this.resource.header("Cookie", FalconClient.AUTH_COOKIE_EQ + FalconClient.this.authenticationToken).accept(operation.mimeType)).type("text/xml")).method(operation.method, ClientResponse.class);
        }

        public ClientResponse call(ExtensionOperations operation) {
            return ((WebResource.Builder)((WebResource.Builder)this.resource.header("Cookie", FalconClient.AUTH_COOKIE_EQ + FalconClient.this.authenticationToken).accept(operation.mimeType)).type("text/xml")).method(operation.method, ClientResponse.class);
        }

        public ClientResponse call(Entities operation, InputStream entityStream) {
            return ((WebResource.Builder)((WebResource.Builder)this.resource.header("Cookie", FalconClient.AUTH_COOKIE_EQ + FalconClient.this.authenticationToken).accept(operation.mimeType)).type("text/xml")).method(operation.method, ClientResponse.class, (Object)entityStream);
        }

        public ClientResponse call(Instances operation, InputStream entityStream) {
            return ((WebResource.Builder)((WebResource.Builder)this.resource.header("Cookie", FalconClient.AUTH_COOKIE_EQ + FalconClient.this.authenticationToken).accept(operation.mimeType)).type("text/xml")).method(operation.method, ClientResponse.class, (Object)entityStream);
        }

        public ClientResponse call(ExtensionOperations operation, InputStream entityStream) {
            return ((WebResource.Builder)((WebResource.Builder)this.resource.header("Cookie", FalconClient.AUTH_COOKIE_EQ + FalconClient.this.authenticationToken).accept(operation.mimeType)).type("text/xml")).method(operation.method, ClientResponse.class, (Object)entityStream);
        }
    }

    protected static enum ExtensionOperations {
        ENUMERATE("api/extension/enumerate/", "GET", "application/json"),
        DESCRIBE("api/extension/describe/", "GET", "text/plain"),
        DEFINITION("api/extension/definition", "GET", "application/json"),
        LIST("api/extension/list", "GET", "application/json"),
        INSTANCES("api/extension/instances", "GET", "application/json"),
        SUBMIT("api/extension/submit", "POST", "text/xml"),
        SUBMIT_AND_SCHEDULE("api/extension/submitAndSchedule", "POST", "text/xml"),
        UPDATE("api/extension/update", "POST", "text/xml"),
        VALIDATE("api/extension/validate", "POST", "text/xml"),
        SCHEDULE("api/extension/schedule", "POST", "text/xml"),
        SUSPEND("api/extension/suspend", "POST", "text/xml"),
        RESUME("api/extension/resume", "POST", "text/xml"),
        DELETE("api/extension/delete", "POST", "text/xml");

        private String path;
        private String method;
        private String mimeType;

        private ExtensionOperations(String path, String method, String mimeType) {
            this.path = path;
            this.method = method;
            this.mimeType = mimeType;
        }
    }

    protected static enum AdminOperations {
        STACK("api/admin/stack", "GET", "text/plain"),
        VERSION("api/admin/version", "GET", "application/json"),
        SAFEMODE("api/admin/setSafeMode", "GET", "application/json");

        private String path;
        private String method;
        private String mimeType;

        private AdminOperations(String path, String method, String mimeType) {
            this.path = path;
            this.method = method;
            this.mimeType = mimeType;
        }
    }

    protected static enum Instances {
        RUNNING("api/instance/running/", "GET", "application/json"),
        STATUS("api/instance/status/", "GET", "application/json"),
        LIST("api/instance/list", "GET", "application/json"),
        KILL("api/instance/kill/", "POST", "application/json"),
        SUSPEND("api/instance/suspend/", "POST", "application/json"),
        RESUME("api/instance/resume/", "POST", "application/json"),
        RERUN("api/instance/rerun/", "POST", "application/json"),
        LOG("api/instance/logs/", "GET", "application/json"),
        SUMMARY("api/instance/summary/", "GET", "application/json"),
        PARAMS("api/instance/params/", "GET", "application/json"),
        DEPENDENCY("api/instance/dependencies/", "GET", "application/json"),
        TRIAGE("api/instance/triage/", "GET", "application/json"),
        LISTING("api/instance/listing/", "GET", "application/json"),
        SEARCH("api/instance/search/", "GET", "application/json");

        private String path;
        private String method;
        private String mimeType;

        private Instances(String path, String method, String mimeType) {
            this.path = path;
            this.method = method;
            this.mimeType = mimeType;
        }
    }

    protected static enum MetadataOperations {
        LIST("api/metadata/discovery/", "GET", "application/json"),
        RELATIONS("api/metadata/discovery/", "GET", "application/json"),
        VERTICES("api/metadata/lineage/vertices", "GET", "application/json"),
        EDGES("api/metadata/lineage/edges", "GET", "application/json"),
        LINEAGE("api/metadata/lineage/entities", "GET", "application/json");

        private String path;
        private String method;
        private String mimeType;

        private MetadataOperations(String path, String method, String mimeType) {
            this.path = path;
            this.method = method;
            this.mimeType = mimeType;
        }
    }

    protected static enum Entities {
        VALIDATE("api/entities/validate/", "POST", "text/xml"),
        SUBMIT("api/entities/submit/", "POST", "text/xml"),
        UPDATE("api/entities/update/", "POST", "text/xml"),
        UPDATEDEPENDENTS("api/entities/updateClusterDependents/", "POST", "text/xml"),
        SUBMITANDSCHEDULE("api/entities/submitAndSchedule/", "POST", "text/xml"),
        SCHEDULE("api/entities/schedule/", "POST", "text/xml"),
        SUSPEND("api/entities/suspend/", "POST", "text/xml"),
        RESUME("api/entities/resume/", "POST", "text/xml"),
        DELETE("api/entities/delete/", "DELETE", "text/xml"),
        STATUS("api/entities/status/", "GET", "text/xml"),
        DEFINITION("api/entities/definition/", "GET", "text/xml"),
        LIST("api/entities/list/", "GET", "text/xml"),
        SUMMARY("api/entities/summary", "GET", "application/json"),
        LOOKUP("api/entities/lookup/", "GET", "application/json"),
        DEPENDENCY("api/entities/dependencies/", "GET", "text/xml"),
        SLA("api/entities/sla-alert", "GET", "application/json"),
        TOUCH("api/entities/touch", "POST", "text/xml");

        private String path;
        private String method;
        private String mimeType;

        private Entities(String path, String method, String mimeType) {
            this.path = path;
            this.method = method;
            this.mimeType = mimeType;
        }
    }
}

