/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.falcon.LifeCycle;
import org.apache.falcon.client.FalconCLIException;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.resource.APIResult;
import org.apache.falcon.resource.EntityList;
import org.apache.falcon.resource.EntitySummaryResult;
import org.apache.falcon.resource.FeedInstanceResult;
import org.apache.falcon.resource.InstanceDependencyResult;
import org.apache.falcon.resource.InstancesResult;
import org.apache.falcon.resource.InstancesSummaryResult;

public abstract class AbstractFalconClient {
    protected static final String FALCON_INSTANCE_ACTION_CLUSTERS = "falcon.instance.action.clusters";
    protected static final String FALCON_INSTANCE_SOURCE_CLUSTERS = "falcon.instance.source.clusters";

    public abstract APIResult submit(String var1, String var2, String var3) throws FalconCLIException, IOException;

    public abstract APIResult schedule(EntityType var1, String var2, String var3, Boolean var4, String var5, String var6) throws FalconCLIException;

    public abstract APIResult delete(EntityType var1, String var2, String var3) throws FalconCLIException;

    public abstract APIResult validate(String var1, String var2, Boolean var3, String var4) throws FalconCLIException;

    public abstract APIResult update(String var1, String var2, String var3, Boolean var4, String var5) throws FalconCLIException;

    public abstract Entity getDefinition(String var1, String var2, String var3) throws FalconCLIException;

    public abstract InstancesResult getStatusOfInstances(String var1, String var2, String var3, String var4, String var5, List<LifeCycle> var6, String var7, String var8, String var9, Integer var10, Integer var11, String var12, Boolean var13) throws FalconCLIException;

    public abstract APIResult suspend(EntityType var1, String var2, String var3, String var4) throws FalconCLIException;

    public abstract APIResult resume(EntityType var1, String var2, String var3, String var4) throws FalconCLIException;

    public abstract APIResult getStatus(EntityType var1, String var2, String var3, String var4, boolean var5) throws FalconCLIException;

    public abstract APIResult submitAndSchedule(String var1, String var2, Boolean var3, String var4, String var5) throws FalconCLIException;

    public abstract EntityList getEntityList(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, Integer var9, Integer var10, String var11) throws FalconCLIException;

    public abstract EntitySummaryResult getEntitySummary(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, Integer var10, Integer var11, Integer var12, String var13) throws FalconCLIException;

    public abstract APIResult touch(String var1, String var2, String var3, Boolean var4, String var5) throws FalconCLIException;

    public abstract InstancesResult killInstances(String var1, String var2, String var3, String var4, String var5, String var6, String var7, List<LifeCycle> var8, String var9) throws FalconCLIException, UnsupportedEncodingException;

    public abstract InstancesResult suspendInstances(String var1, String var2, String var3, String var4, String var5, String var6, String var7, List<LifeCycle> var8, String var9) throws FalconCLIException, UnsupportedEncodingException;

    public abstract InstancesResult resumeInstances(String var1, String var2, String var3, String var4, String var5, String var6, String var7, List<LifeCycle> var8, String var9) throws FalconCLIException, UnsupportedEncodingException;

    public abstract InstancesResult rerunInstances(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, List<LifeCycle> var9, Boolean var10, String var11) throws FalconCLIException, IOException;

    public abstract InstancesSummaryResult getSummaryOfInstances(String var1, String var2, String var3, String var4, String var5, List<LifeCycle> var6, String var7, String var8, String var9, String var10) throws FalconCLIException;

    public abstract FeedInstanceResult getFeedListing(String var1, String var2, String var3, String var4, String var5, String var6) throws FalconCLIException;

    public abstract InstancesResult getLogsOfInstances(String var1, String var2, String var3, String var4, String var5, String var6, List<LifeCycle> var7, String var8, String var9, String var10, Integer var11, Integer var12, String var13) throws FalconCLIException;

    public abstract InstancesResult getParamsOfInstance(String var1, String var2, String var3, String var4, List<LifeCycle> var5, String var6) throws FalconCLIException, UnsupportedEncodingException;

    public abstract InstanceDependencyResult getInstanceDependencies(String var1, String var2, String var3, String var4) throws FalconCLIException;

    public abstract String getVersion(String var1) throws FalconCLIException;

    protected InputStream getServletInputStream(String clusters, String sourceClusters, String properties) throws FalconCLIException, UnsupportedEncodingException {
        StringBuilder buffer = new StringBuilder();
        if (clusters != null) {
            buffer.append(FALCON_INSTANCE_ACTION_CLUSTERS).append('=').append(clusters).append('\n');
        }
        if (sourceClusters != null) {
            buffer.append(FALCON_INSTANCE_SOURCE_CLUSTERS).append('=').append(sourceClusters).append('\n');
        }
        if (properties != null) {
            buffer.append(properties);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer.toString().getBytes());
        return buffer.length() == 0 ? null : stream;
    }
}

