/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.cli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.cli.FalconCLIRuntimeException;
import org.apache.falcon.client.FalconCLIException;
import org.apache.falcon.client.FalconClient;
import org.springframework.shell.core.ExecutionProcessor;
import org.springframework.shell.event.ParseResult;

public class BaseFalconCommands
implements ExecutionProcessor {
    private static final String FALCON_URL = "FALCON_URL";
    private static final String FALCON_URL_PROPERTY = "falcon.url";
    private static final String DO_AS = "DO_AS";
    private static final String DO_AS_PROPERTY = "do.as";
    private static final String CLIENT_PROPERTIES = "/client.properties";
    private static Properties clientProperties;
    private static Properties backupProperties;
    private static FalconClient client;

    protected static Properties getClientProperties() {
        if (clientProperties == null) {
            Properties prop;
            block9: {
                InputStream inputStream = null;
                prop = new Properties(System.getProperties());
                prop.putAll((Map<?, ?>)backupProperties);
                try {
                    inputStream = BaseFalconCommands.class.getResourceAsStream(CLIENT_PROPERTIES);
                    if (inputStream == null) break block9;
                    try {
                        prop.load(inputStream);
                    }
                    catch (IOException e) {
                        throw new FalconCLIRuntimeException(e);
                    }
                }
                finally {
                    IOUtils.closeQuietly(inputStream);
                }
            }
            String urlOverride = System.getenv(FALCON_URL);
            if (urlOverride != null) {
                prop.setProperty(FALCON_URL_PROPERTY, urlOverride);
            }
            if (prop.getProperty(FALCON_URL_PROPERTY) == null) {
                throw new FalconCLIRuntimeException("Failed to get falcon url from environment or client properties");
            }
            String doAsOverride = System.getenv(DO_AS);
            if (doAsOverride != null) {
                prop.setProperty(DO_AS_PROPERTY, doAsOverride);
            }
            clientProperties = prop;
            backupProperties.clear();
        }
        return clientProperties;
    }

    static void setClientProperty(String key, String value) {
        Properties props;
        try {
            props = BaseFalconCommands.getClientProperties();
        }
        catch (FalconCLIRuntimeException e) {
            props = backupProperties;
        }
        if (StringUtils.isBlank(value)) {
            props.remove(key);
        } else {
            props.setProperty(key, value);
        }
        client = null;
    }

    public static FalconClient getFalconClient() {
        if (client == null) {
            try {
                client = new FalconClient(BaseFalconCommands.getClientProperties().getProperty(FALCON_URL_PROPERTY), BaseFalconCommands.getClientProperties());
            }
            catch (FalconCLIException e) {
                throw new FalconCLIRuntimeException(e.getMessage(), e.getCause());
            }
        }
        return client;
    }

    @Override
    public ParseResult beforeInvocation(ParseResult parseResult) {
        Object[] args = parseResult.getArguments();
        if (args != null) {
            boolean allEqual = true;
            for (int i = 1; i < args.length; ++i) {
                allEqual &= args[0].equals(args[i]);
            }
            if (allEqual && args[0] instanceof String) {
                String[] split = ((String)args[0]).split("\\s+");
                Object[] newArgs = new String[args.length];
                System.arraycopy(split, 0, newArgs, 0, split.length);
                parseResult = new ParseResult(parseResult.getMethod(), parseResult.getInstance(), newArgs);
            }
        }
        return parseResult;
    }

    @Override
    public void afterReturningInvocation(ParseResult parseResult, Object o) {
    }

    @Override
    public void afterThrowingInvocation(ParseResult parseResult, Throwable throwable) {
    }

    static {
        backupProperties = new Properties();
    }
}

