/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.logging;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.shell.support.util.IOUtils;
import org.springframework.util.FileCopyUtils;

public abstract class MessageDisplayUtils {
    private static Logger LOGGER = HandlerUtils.getLogger(MessageDisplayUtils.class);

    public static void displayFile(String fileName, Class<?> owner, boolean important) {
        Level level = important ? Level.SEVERE : Level.FINE;
        String owningPackage = owner.getPackage().getName().replace('.', '/');
        String fullResourceName = "/" + owningPackage + "/" + fileName;
        InputStream inputStream = owner.getClassLoader().getResourceAsStream(fullResourceName);
        if (inputStream == null) {
            throw new IllegalStateException("Could not locate '" + fileName + "'");
        }
        try {
            String message = FileCopyUtils.copyToString(new InputStreamReader(new BufferedInputStream(inputStream)));
            LOGGER.log(level, message);
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
    }

    public static void displayFile(String fileName, Class<?> owner) {
        MessageDisplayUtils.displayFile(fileName, owner, false);
    }
}

