/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.event;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.springframework.shell.event.ParseResult;
import org.springframework.shell.event.ShellStatus;
import org.springframework.shell.event.ShellStatusListener;
import org.springframework.shell.event.ShellStatusProvider;
import org.springframework.util.Assert;

public abstract class AbstractShellStatusPublisher
implements ShellStatusProvider {
    protected Set<ShellStatusListener> shellStatusListeners = new CopyOnWriteArraySet<ShellStatusListener>();
    protected ShellStatus shellStatus = new ShellStatus(ShellStatus.Status.STARTING);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addShellStatusListener(ShellStatusListener shellStatusListener) {
        Assert.notNull(shellStatusListener, "Status listener required");
        ShellStatus shellStatus = this.shellStatus;
        synchronized (shellStatus) {
            this.shellStatusListeners.add(shellStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeShellStatusListener(ShellStatusListener shellStatusListener) {
        Assert.notNull(shellStatusListener, "Status listener required");
        ShellStatus shellStatus = this.shellStatus;
        synchronized (shellStatus) {
            this.shellStatusListeners.remove(shellStatusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ShellStatus getShellStatus() {
        ShellStatus shellStatus = this.shellStatus;
        synchronized (shellStatus) {
            return this.shellStatus;
        }
    }

    protected void setShellStatus(ShellStatus.Status shellStatus) {
        this.setShellStatus(shellStatus, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setShellStatus(ShellStatus.Status shellStatus, String msg, ParseResult parseResult) {
        Assert.notNull((Object)shellStatus, "Shell status required");
        ShellStatus shellStatus2 = this.shellStatus;
        synchronized (shellStatus2) {
            ShellStatus st = msg == null || msg.length() == 0 ? new ShellStatus(shellStatus) : new ShellStatus(shellStatus, msg, parseResult);
            if (this.shellStatus.equals(st)) {
                return;
            }
            for (ShellStatusListener listener : this.shellStatusListeners) {
                listener.onShellStatusChange(this.shellStatus, st);
            }
            this.shellStatus = st;
        }
    }
}

