/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.core;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.shell.core.CommandResult;
import org.springframework.shell.core.ExecutionStrategy;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.core.Parser;
import org.springframework.shell.core.Shell;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.event.AbstractShellStatusPublisher;
import org.springframework.shell.event.ParseResult;
import org.springframework.shell.event.ShellStatus;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.shell.support.util.VersionUtils;
import org.springframework.util.Assert;

public abstract class AbstractShell
extends AbstractShellStatusPublisher
implements Shell {
    private static final String MY_SLOT = AbstractShell.class.getName();
    protected static final String ROO_PROMPT = "spring> ";
    public static String completionKeys = "TAB";
    public static String shellPrompt = "spring> ";
    protected final Logger logger = HandlerUtils.getLogger(this.getClass());
    protected boolean inBlockComment;
    protected ExitShellRequest exitShellRequest;

    protected abstract String getHomeAsString();

    protected abstract ExecutionStrategy getExecutionStrategy();

    protected abstract Parser getParser();

    public boolean executeScriptLine(String line) {
        return this.executeCommand(line).isSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult executeCommand(String line) {
        this.setShellStatus(ShellStatus.Status.PARSING);
        ExecutionStrategy executionStrategy = this.getExecutionStrategy();
        boolean flashedMessage = false;
        while (executionStrategy == null || !executionStrategy.isReadyForCommands()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (flashedMessage) continue;
            this.flash(Level.INFO, "Please wait - still loading", MY_SLOT);
            flashedMessage = true;
        }
        if (flashedMessage) {
            this.flash(Level.INFO, "", MY_SLOT);
        }
        ParseResult parseResult = null;
        try {
            Object lhs;
            if (!this.inBlockComment && ((String)line).contains("/*") && ((String)line).contains("*/")) {
                this.blockCommentBegin();
                lhs = ((String)line).substring(0, ((String)line).lastIndexOf("/*"));
                if (((String)line).contains("*/")) {
                    line = (String)lhs + ((String)line).substring(((String)line).lastIndexOf("*/") + 2);
                    this.blockCommentFinish();
                } else {
                    line = lhs;
                }
            }
            if (this.inBlockComment) {
                if (!((String)line).contains("*/")) {
                    lhs = new CommandResult(true);
                    return lhs;
                }
                this.blockCommentFinish();
                line = ((String)line).substring(((String)line).lastIndexOf("*/") + 2);
            }
            if (!this.inBlockComment && (((String)line).trim().startsWith("//") || ((String)line).trim().startsWith("#"))) {
                line = "";
            }
            if ("".equals(((String)(line = ((String)line).replace('\t', ' '))).trim())) {
                this.setShellStatus(ShellStatus.Status.EXECUTION_SUCCESS);
                lhs = new CommandResult(true);
                return lhs;
            }
            parseResult = this.getParser().parse((String)line);
            if (parseResult == null) {
                lhs = new CommandResult(false);
                return lhs;
            }
            this.setShellStatus(ShellStatus.Status.EXECUTING);
            Object result = executionStrategy.execute(parseResult);
            this.setShellStatus(ShellStatus.Status.EXECUTION_RESULT_PROCESSING);
            if (result != null) {
                if (result instanceof ExitShellRequest) {
                    this.exitShellRequest = (ExitShellRequest)result;
                    executionStrategy.terminate();
                } else {
                    this.handleExecutionResult(result);
                }
            }
            this.logCommandIfRequired((String)line, true);
            this.setShellStatus(ShellStatus.Status.EXECUTION_SUCCESS, (String)line, parseResult);
            CommandResult commandResult = new CommandResult(true, result, null);
            return commandResult;
        }
        catch (RuntimeException e) {
            this.setShellStatus(ShellStatus.Status.EXECUTION_FAILED, (String)line, parseResult);
            try {
                this.logCommandIfRequired((String)line, false);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            CommandResult commandResult = new CommandResult(false, null, e);
            return commandResult;
        }
        finally {
            this.setShellStatus(ShellStatus.Status.USER_INPUT);
        }
    }

    protected void logCommandIfRequired(String line, boolean successful) {
        if (line.startsWith("script")) {
            this.logCommandToOutput((successful ? "// " : "// [failed] ") + line);
        } else {
            this.logCommandToOutput((successful ? "" : "// [failed] ") + line);
        }
    }

    protected void logCommandToOutput(String processedLine) {
    }

    @Override
    public void setPromptPath(String path) {
        shellPrompt = path == null || "".equals(path) ? ROO_PROMPT : path + " " + ROO_PROMPT;
    }

    @Override
    public void setPromptPath(String path, boolean overrideStyle) {
        this.setPromptPath(path);
    }

    @Override
    public ExitShellRequest getExitShellRequest() {
        return this.exitShellRequest;
    }

    @CliCommand(value={"/*"}, help="Start of block comment")
    public void blockCommentBegin() {
        Assert.isTrue(!this.inBlockComment, "Cannot open a new block comment when one already active");
        this.inBlockComment = true;
    }

    @CliCommand(value={"*/"}, help="End of block comment")
    public void blockCommentFinish() {
        Assert.isTrue(this.inBlockComment, "Cannot close a block comment when it has not been opened");
        this.inBlockComment = false;
    }

    public String versionInfo() {
        return VersionUtils.versionInfo();
    }

    @Override
    public String getShellPrompt() {
        return shellPrompt;
    }

    @Override
    public File getHome() {
        String rooHome = this.getHomeAsString();
        File f = new File(rooHome);
        Assert.isTrue(!f.exists() || f.exists() && f.isDirectory(), "Path '" + f.getAbsolutePath() + "' must be a directory, or it must not exist");
        if (!f.exists()) {
            f.mkdirs();
        }
        Assert.isTrue(f.exists() && f.isDirectory(), "Path '" + f.getAbsolutePath() + "' is not a directory; please specify roo.home system property correctly");
        return f;
    }

    @Override
    public void flash(Level level, String message, String slot) {
        Assert.notNull(level, "Level is required for a flash message");
        Assert.notNull(message, "Message is required for a flash message");
        Assert.hasText(slot, "Slot name must be specified for a flash message");
        if (!"".equals(message)) {
            this.logger.log(level, message);
        }
    }

    protected void handleExecutionResult(Object result) {
        if (result instanceof Iterable) {
            for (Object o : (Iterable)result) {
                this.logger.info(o.toString());
            }
        } else {
            this.logger.info(result.toString());
        }
    }
}

