/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.workflow;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.SchemaHelper;
import org.apache.falcon.hadoop.HadoopClientFactory;
import org.apache.falcon.workflow.WorkflowEngineFactory;
import org.apache.falcon.workflow.WorkflowExecutionArgs;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowExecutionContext.class);
    public static final String INSTANCE_FORMAT = "yyyy-MM-dd-HH-mm";
    public static final String OUTPUT_FEED_SEPARATOR = ",";
    public static final String INPUT_FEED_SEPARATOR = "#";
    public static final String CLUSTER_NAME_SEPARATOR = ",";
    public static final WorkflowExecutionArgs[] USER_MESSAGE_ARGS = new WorkflowExecutionArgs[]{WorkflowExecutionArgs.CLUSTER_NAME, WorkflowExecutionArgs.ENTITY_NAME, WorkflowExecutionArgs.ENTITY_TYPE, WorkflowExecutionArgs.NOMINAL_TIME, WorkflowExecutionArgs.OPERATION, WorkflowExecutionArgs.OUTPUT_FEED_NAMES, WorkflowExecutionArgs.OUTPUT_FEED_PATHS, WorkflowExecutionArgs.WORKFLOW_ID, WorkflowExecutionArgs.WORKFLOW_USER, WorkflowExecutionArgs.RUN_ID, WorkflowExecutionArgs.STATUS, WorkflowExecutionArgs.TIMESTAMP, WorkflowExecutionArgs.LOG_DIR};
    private final Map<WorkflowExecutionArgs, String> context;
    private final long creationTime;
    private Configuration actionJobConf;

    public WorkflowExecutionContext(Map<WorkflowExecutionArgs, String> context) {
        this.context = context;
        this.creationTime = System.currentTimeMillis();
    }

    public String getValue(WorkflowExecutionArgs arg) {
        return this.context.get((Object)arg);
    }

    public void setValue(WorkflowExecutionArgs arg, String value) {
        this.context.put(arg, value);
    }

    public String getValue(WorkflowExecutionArgs arg, String defaultValue) {
        return this.context.containsKey((Object)arg) ? this.context.get((Object)arg) : defaultValue;
    }

    public boolean containsKey(WorkflowExecutionArgs arg) {
        return this.context.containsKey((Object)arg);
    }

    public Set<Map.Entry<WorkflowExecutionArgs, String>> entrySet() {
        return this.context.entrySet();
    }

    public boolean hasWorkflowSucceeded() {
        return Status.SUCCEEDED.name().equals(this.getValue(WorkflowExecutionArgs.STATUS));
    }

    public boolean hasWorkflowFailed() {
        return Status.FAILED.name().equals(this.getValue(WorkflowExecutionArgs.STATUS));
    }

    public boolean isWorkflowKilledManually() {
        try {
            return WorkflowEngineFactory.getWorkflowEngine().isWorkflowKilledByUser(this.getValue(WorkflowExecutionArgs.CLUSTER_NAME), this.getValue(WorkflowExecutionArgs.WORKFLOW_ID));
        }
        catch (Exception e) {
            LOG.error("Got Error in getting error codes from actions: " + e);
            return false;
        }
    }

    public boolean hasWorkflowTimedOut() {
        return Status.TIMEDOUT.name().equals(this.getValue(WorkflowExecutionArgs.STATUS));
    }

    public boolean hasWorkflowBeenKilled() {
        return Status.KILLED.name().equals(this.getValue(WorkflowExecutionArgs.STATUS));
    }

    public String getContextFile() {
        return this.getValue(WorkflowExecutionArgs.CONTEXT_FILE);
    }

    public Status getWorkflowStatus() {
        return Status.valueOf(this.getValue(WorkflowExecutionArgs.STATUS));
    }

    public String getLogDir() {
        return this.getValue(WorkflowExecutionArgs.LOG_DIR);
    }

    public String getLogFile() {
        return this.getValue(WorkflowExecutionArgs.LOG_FILE);
    }

    String getNominalTime() {
        return this.getValue(WorkflowExecutionArgs.NOMINAL_TIME);
    }

    public String getNominalTimeAsISO8601() {
        return SchemaHelper.formatDateUTCToISO8601(this.getNominalTime(), INSTANCE_FORMAT);
    }

    String getTimestamp() {
        return this.getValue(WorkflowExecutionArgs.TIMESTAMP);
    }

    public long getTimeStampAsLong() {
        String dateString = this.getTimestamp();
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(INSTANCE_FORMAT.substring(0, dateString.length()));
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat.parse(dateString).getTime();
        }
        catch (java.text.ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTimeStampAsISO8601() {
        return SchemaHelper.formatDateUTCToISO8601(this.getTimestamp(), INSTANCE_FORMAT);
    }

    public String getClusterName() {
        String value = this.getValue(WorkflowExecutionArgs.CLUSTER_NAME);
        if (EntityOperations.REPLICATE != this.getOperation()) {
            return value;
        }
        return value.split(",")[0];
    }

    public String getSrcClusterName() {
        String value = this.getValue(WorkflowExecutionArgs.CLUSTER_NAME);
        if (EntityOperations.REPLICATE != this.getOperation()) {
            return value;
        }
        String[] parts = value.split(",");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Replicated cluster pair is missing in " + value);
        }
        return parts[1];
    }

    public String getEntityName() {
        return this.getValue(WorkflowExecutionArgs.ENTITY_NAME);
    }

    public String getEntityType() {
        return this.getValue(WorkflowExecutionArgs.ENTITY_TYPE).toUpperCase();
    }

    public EntityOperations getOperation() {
        if (this.getValue(WorkflowExecutionArgs.OPERATION) != null) {
            return EntityOperations.valueOf(this.getValue(WorkflowExecutionArgs.OPERATION));
        }
        return EntityOperations.valueOf(this.getValue(WorkflowExecutionArgs.DATA_OPERATION));
    }

    public String getOutputFeedNames() {
        return this.getValue(WorkflowExecutionArgs.OUTPUT_FEED_NAMES);
    }

    public String[] getOutputFeedNamesList() {
        return this.getOutputFeedNames().split(",");
    }

    public String getOutputFeedInstancePaths() {
        return this.getValue(WorkflowExecutionArgs.OUTPUT_FEED_PATHS);
    }

    public String[] getOutputFeedInstancePathsList() {
        return this.getOutputFeedInstancePaths().split(",");
    }

    public String getInputFeedNames() {
        return this.getValue(WorkflowExecutionArgs.INPUT_FEED_NAMES);
    }

    public String[] getInputFeedNamesList() {
        return this.getInputFeedNames().split(INPUT_FEED_SEPARATOR);
    }

    public String getInputFeedInstancePaths() {
        return this.getValue(WorkflowExecutionArgs.INPUT_FEED_PATHS);
    }

    public String[] getInputFeedInstancePathsList() {
        return this.getInputFeedInstancePaths().split(INPUT_FEED_SEPARATOR);
    }

    public String getWorkflowEngineUrl() {
        return this.getValue(WorkflowExecutionArgs.WF_ENGINE_URL);
    }

    public String getUserWorkflowEngine() {
        return this.getValue(WorkflowExecutionArgs.USER_WORKFLOW_ENGINE);
    }

    public String getUserWorkflowVersion() {
        return this.getValue(WorkflowExecutionArgs.USER_WORKFLOW_VERSION);
    }

    public String getWorkflowId() {
        return this.getValue(WorkflowExecutionArgs.WORKFLOW_ID);
    }

    public String getWorkflowParentId() {
        return this.getValue(WorkflowExecutionArgs.PARENT_ID);
    }

    public String getUserSubflowId() {
        return this.getValue(WorkflowExecutionArgs.USER_SUBFLOW_ID);
    }

    public int getWorkflowRunId() {
        return Integer.parseInt(this.getValue(WorkflowExecutionArgs.RUN_ID));
    }

    public String getWorkflowRunIdString() {
        return String.valueOf(Integer.parseInt(this.getValue(WorkflowExecutionArgs.RUN_ID)));
    }

    public String getWorkflowUser() {
        return this.getValue(WorkflowExecutionArgs.WORKFLOW_USER);
    }

    public long getExecutionCompletionTime() {
        return this.creationTime;
    }

    public String getDatasourceName() {
        return this.getValue(WorkflowExecutionArgs.DATASOURCE_NAME);
    }

    public long getWorkflowStartTime() {
        return Long.parseLong(this.getValue(WorkflowExecutionArgs.WF_START_TIME));
    }

    public long getWorkflowEndTime() {
        return Long.parseLong(this.getValue(WorkflowExecutionArgs.WF_END_TIME));
    }

    public Type getContextType() {
        return Type.valueOf(this.getValue(WorkflowExecutionArgs.CONTEXT_TYPE));
    }

    public String getCounters() {
        return this.getValue(WorkflowExecutionArgs.COUNTERS);
    }

    public void serialize() throws IOException, FalconException {
        this.serialize(this.getContextFile());
    }

    public void serialize(String contextFile) throws FalconException {
        LOG.info("Saving context to: [{}]", (Object)contextFile);
        OutputStream out = null;
        Path file = new Path(contextFile);
        try {
            FileSystem fs = this.actionJobConf == null ? HadoopClientFactory.get().createProxiedFileSystem(file.toUri()) : HadoopClientFactory.get().createProxiedFileSystem(file.toUri(), this.actionJobConf);
            out = fs.create(file);
            out.write(JSONValue.toJSONString(this.context).getBytes());
        }
        catch (IOException e) {
            throw new FalconException("Error serializing context to: " + contextFile, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public String toString() {
        return "WorkflowExecutionContext{" + this.context.toString() + "}";
    }

    public static WorkflowExecutionContext deSerialize(String contextFile) throws FalconException {
        try {
            Path lineageDataPath = new Path(contextFile);
            FileSystem fs = HadoopClientFactory.get().createProxiedFileSystem(lineageDataPath.toUri());
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(lineageDataPath)));
            return new WorkflowExecutionContext((Map)JSONValue.parse((Reader)in));
        }
        catch (IOException e) {
            throw new FalconException("Error opening context file: " + contextFile, e);
        }
    }

    public static String getFilePath(String logDir, String entityName, String entityType, EntityOperations operation) {
        String parentSuffix = EntityType.PROCESS.name().equals(entityType) || EntityOperations.REPLICATE == operation ? "" : "/context/";
        return new Path(logDir + parentSuffix, entityName + "-wf-post-exec-context.json").toString();
    }

    public static Path getCounterFile(String logDir) {
        return new Path(logDir, "counter.txt");
    }

    public static String readCounters(FileSystem fs, Path counterFile) throws IOException {
        StringBuilder counterBuffer = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(counterFile)));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                counterBuffer.append(line);
                counterBuffer.append(",");
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
        String counterString = counterBuffer.toString();
        if (StringUtils.isNotBlank(counterString) && counterString.length() > 0) {
            return counterString.substring(0, counterString.length() - 1);
        }
        return null;
    }

    public static WorkflowExecutionContext create(String[] args, Type type) throws FalconException {
        return WorkflowExecutionContext.create(args, type, null);
    }

    public static WorkflowExecutionContext create(String[] args, Type type, Configuration conf) throws FalconException {
        HashMap<WorkflowExecutionArgs, String> wfProperties = new HashMap<WorkflowExecutionArgs, String>();
        try {
            CommandLine cmd = WorkflowExecutionContext.getCommand(args);
            for (WorkflowExecutionArgs arg : WorkflowExecutionArgs.values()) {
                String optionValue = arg.getOptionValue(cmd);
                if (!StringUtils.isNotEmpty(optionValue)) continue;
                wfProperties.put(arg, optionValue);
            }
        }
        catch (ParseException e) {
            throw new FalconException("Error parsing wf args", e);
        }
        WorkflowExecutionContext executionContext = new WorkflowExecutionContext(wfProperties);
        executionContext.actionJobConf = conf;
        executionContext.context.put(WorkflowExecutionArgs.CONTEXT_TYPE, type.name());
        executionContext.context.put(WorkflowExecutionArgs.CONTEXT_FILE, WorkflowExecutionContext.getFilePath(executionContext.getLogDir(), executionContext.getEntityName(), executionContext.getEntityType(), executionContext.getOperation()));
        WorkflowExecutionContext.addCounterToWF(executionContext);
        return executionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCounterToWF(WorkflowExecutionContext executionContext) throws FalconException {
        if (executionContext.hasWorkflowFailed()) {
            LOG.info("Workflow Instance failed, counter will not be added: {}", (Object)executionContext.getWorkflowRunIdString());
            return;
        }
        FileSystem fs = HadoopClientFactory.get().createProxiedFileSystem(new Path(executionContext.getLogDir()).toUri());
        Path counterFile = WorkflowExecutionContext.getCounterFile(executionContext.getLogDir());
        try {
            String counters;
            if (fs.exists(counterFile) && StringUtils.isNotBlank(counters = WorkflowExecutionContext.readCounters(fs, counterFile))) {
                executionContext.context.put(WorkflowExecutionArgs.COUNTERS, counters);
            }
        }
        catch (IOException e) {
            LOG.error("Error in accessing counter file :" + e);
        }
        finally {
            try {
                if (fs.exists(counterFile)) {
                    fs.delete(counterFile, false);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to delete counter file: {}", (Throwable)e);
            }
        }
    }

    private static CommandLine getCommand(String[] arguments) throws ParseException {
        Options options = new Options();
        for (WorkflowExecutionArgs arg : WorkflowExecutionArgs.values()) {
            WorkflowExecutionContext.addOption(options, arg, arg.isRequired());
        }
        return new GnuParser().parse(options, arguments, false);
    }

    private static void addOption(Options options, WorkflowExecutionArgs arg, boolean isRequired) {
        Option option = arg.getOption();
        option.setRequired(isRequired);
        options.addOption(option);
    }

    public static WorkflowExecutionContext create(Map<WorkflowExecutionArgs, String> wfProperties) {
        return WorkflowExecutionContext.create(wfProperties, Type.POST_PROCESSING);
    }

    public static WorkflowExecutionContext create(Map<WorkflowExecutionArgs, String> wfProperties, Type type) {
        wfProperties.put(WorkflowExecutionArgs.CONTEXT_TYPE, type.name());
        return new WorkflowExecutionContext(wfProperties);
    }

    public static enum EntityOperations {
        GENERATE,
        DELETE,
        REPLICATE,
        IMPORT,
        EXPORT;

    }

    public static enum Type {
        PRE_PROCESSING,
        POST_PROCESSING,
        WORKFLOW_JOB,
        COORDINATOR_ACTION;

    }

    public static enum Status {
        WAITING,
        RUNNING,
        SUSPENDED,
        SUCCEEDED,
        FAILED,
        TIMEDOUT,
        KILLED;

    }
}

