/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.workflow;

import java.util.Map;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.lifecycle.AbstractPolicyBuilderFactory;
import org.apache.falcon.util.ReflectionUtils;
import org.apache.falcon.workflow.engine.AbstractWorkflowEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkflowEngineFactory {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowEngineFactory.class);
    public static final String ENGINE_PROP = "falcon.scheduler";
    private static AbstractWorkflowEngine nativeWorkflowEngine;
    private static AbstractWorkflowEngine configuredWorkflowEngine;
    private static final String CONFIGURED_WORKFLOW_ENGINE = "workflow.engine.impl";
    private static final String LIFECYCLE_ENGINE = "lifecycle.engine.impl";

    private WorkflowEngineFactory() {
    }

    public static AbstractWorkflowEngine getWorkflowEngine(Entity entity) throws FalconException {
        if (entity != null && entity.getEntityType().isSchedulable() && WorkflowEngineFactory.getNativeWorkflowEngine().isActive(entity)) {
            LOG.debug("Returning native workflow engine for entity {}", (Object)entity.getName());
            return nativeWorkflowEngine;
        }
        LOG.debug("Returning configured workflow engine for entity {}.", (Object)entity);
        return WorkflowEngineFactory.getWorkflowEngine();
    }

    public static AbstractWorkflowEngine getWorkflowEngine(Entity entity, Map<String, String> props) throws FalconException {
        if (entity == null || !entity.getEntityType().isSchedulable()) {
            LOG.debug("Returning configured workflow engine for entity {}.", (Object)entity);
            return WorkflowEngineFactory.getWorkflowEngine();
        }
        String engineName = WorkflowEngineFactory.getWorkflowEngine().getName();
        if (props != null && props.containsKey(ENGINE_PROP)) {
            engineName = props.get(ENGINE_PROP);
        }
        if (engineName.equalsIgnoreCase(WorkflowEngineFactory.getWorkflowEngine().getName())) {
            if (WorkflowEngineFactory.getNativeWorkflowEngine().isActive(entity)) {
                throw new FalconException("Entity " + entity.getName() + " is already scheduled on native engine.");
            }
            LOG.debug("Returning configured workflow engine for entity {}", (Object)entity.getName());
            return configuredWorkflowEngine;
        }
        if (engineName.equalsIgnoreCase(WorkflowEngineFactory.getNativeWorkflowEngine().getName())) {
            if (WorkflowEngineFactory.getWorkflowEngine().isActive(entity)) {
                throw new FalconException("Entity " + entity.getName() + " is already scheduled on " + "configured workflow engine.");
            }
            LOG.debug("Returning native workflow engine for entity {}", (Object)entity.getName());
            return nativeWorkflowEngine;
        }
        throw new IllegalArgumentException("Property falcon.scheduler is not set to a valid value.");
    }

    public static AbstractWorkflowEngine getWorkflowEngine() throws FalconException {
        if (configuredWorkflowEngine == null) {
            configuredWorkflowEngine = (AbstractWorkflowEngine)ReflectionUtils.getInstance(CONFIGURED_WORKFLOW_ENGINE);
        }
        return configuredWorkflowEngine;
    }

    public static AbstractWorkflowEngine getNativeWorkflowEngine() throws FalconException {
        if (nativeWorkflowEngine == null) {
            nativeWorkflowEngine = (AbstractWorkflowEngine)ReflectionUtils.getInstanceByClassName("org.apache.falcon.workflow.engine.FalconWorkflowEngine");
        }
        return nativeWorkflowEngine;
    }

    public static AbstractPolicyBuilderFactory getLifecycleEngine() throws FalconException {
        return (AbstractPolicyBuilderFactory)ReflectionUtils.getInstance(LIFECYCLE_ENGINE);
    }
}

