/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.expression.ExpressionHelper;
import org.apache.falcon.util.ApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StateStoreProperties
extends ApplicationProperties {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreProperties.class);
    private static final String PROPERTY_FILE = "statestore.properties";
    private static final String CREDENTIALS_FILE = "falcon.statestore.credentials.file";
    private static final String DEFAULT_CREDENTIALS_FILE = "statestore.credentials";
    private static final AtomicReference<StateStoreProperties> INSTANCE = new AtomicReference();

    protected StateStoreProperties() throws FalconException {
    }

    @Override
    protected String getPropertyFile() {
        return PROPERTY_FILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadProperties() throws FalconException {
        super.loadProperties();
        String credentialsFile = (String)this.get(CREDENTIALS_FILE);
        try {
            InputStream resourceAsStream = null;
            if (StringUtils.isNotBlank((String)credentialsFile)) {
                resourceAsStream = this.getResourceAsStream(new File(credentialsFile));
            }
            if (resourceAsStream == null) {
                resourceAsStream = this.checkClassPath(DEFAULT_CREDENTIALS_FILE);
            }
            if (resourceAsStream != null) {
                try {
                    this.loadCredentials(resourceAsStream);
                    return;
                }
                finally {
                    IOUtils.closeQuietly(resourceAsStream);
                }
            }
            throw new FalconException("Unable to find state store credentials file");
        }
        catch (IOException e) {
            throw new FalconException("Error loading properties file: " + this.getPropertyFile(), e);
        }
    }

    private void loadCredentials(InputStream resourceAsStream) throws IOException {
        Properties origProps = new Properties();
        origProps.load(resourceAsStream);
        LOG.info("Initializing {} properties with domain {}", (Object)this.getClass().getName(), (Object)this.domain);
        Set<String> keys = this.getKeys(origProps.keySet());
        for (String key : keys) {
            String value = origProps.getProperty(this.domain + "." + key, origProps.getProperty("*." + key));
            if (value == null) continue;
            value = ExpressionHelper.substitute(value);
            LOG.debug("{}={}", (Object)key, (Object)value);
            this.put(key, value);
        }
    }

    public static Properties get() {
        try {
            if (INSTANCE.get() == null) {
                INSTANCE.compareAndSet(null, new StateStoreProperties());
            }
            return INSTANCE.get();
        }
        catch (FalconException e) {
            throw new RuntimeException("Unable to read application state store properties", e);
        }
    }
}

