/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsClassLoader
extends URLClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsClassLoader.class);
    private static Map<String, HdfsClassLoader> classLoaderCache = new ConcurrentHashMap<String, HdfsClassLoader>();
    private static final Object LOCK = new Object();
    private final ClassLoader realParent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader load(final String name, List<String> jarHdfsPath) throws IOException {
        LOG.info("ClassLoader cache size = " + classLoaderCache.size());
        if (classLoaderCache.containsKey(name)) {
            return classLoaderCache.get(name);
        }
        Object object = LOCK;
        synchronized (object) {
            final URL[] urls = HdfsClassLoader.copyHdfsJarFilesToTempDir(name, jarHdfsPath);
            LOG.info("Copied jar files from HDFS to local dir");
            final ClassLoader parentClassLoader = HdfsClassLoader.class.getClassLoader();
            HdfsClassLoader hdfsClassLoader = AccessController.doPrivileged(new PrivilegedAction<HdfsClassLoader>(){

                @Override
                public HdfsClassLoader run() {
                    return new HdfsClassLoader(name, urls, parentClassLoader);
                }
            });
            LOG.info("Created a new HdfsClassLoader for name = {} with parent = {} using classpath = {}", new Object[]{name, parentClassLoader.toString(), Arrays.toString(jarHdfsPath.toArray())});
            classLoaderCache.put(name, hdfsClassLoader);
            return hdfsClassLoader;
        }
    }

    public HdfsClassLoader(String name, URL[] urls, ClassLoader parentClassLoader) {
        super(urls, (ClassLoader)null);
        this.realParent = parentClassLoader;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.realParent.loadClass(name);
        }
        catch (Throwable t) {
            return super.loadClass(name, resolve);
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = this.realParent.getResource(name);
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    private static URL[] copyHdfsJarFilesToTempDir(String databaseName, List<String> jars) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Configuration conf = new Configuration();
        Path localPath = HdfsClassLoader.createTempDir(databaseName, conf);
        for (String jar : jars) {
            Path jarPath = new Path(jar);
            FileSystem fs = jarPath.getFileSystem(conf);
            if (!fs.isFile(jarPath) || !jarPath.getName().endsWith(".jar")) continue;
            LOG.info("Copying jarFile = " + jarPath);
            fs.copyToLocalFile(jarPath, localPath);
        }
        urls.addAll(HdfsClassLoader.getJarsInPath(localPath.toUri().toURL()));
        return urls.toArray(new URL[urls.size()]);
    }

    private static Path createTempDir(String databaseName, Configuration conf) throws IOException {
        String tmpBaseDir = String.format("file://%s", System.getProperty("java.io.tmpdir"));
        if (StringUtils.isBlank(tmpBaseDir)) {
            tmpBaseDir = "file:///tmp";
        }
        Path localPath = new Path(tmpBaseDir, databaseName);
        localPath.getFileSystem(conf).mkdirs(localPath);
        return localPath;
    }

    private static List<URL> getJarsInPath(URL fileURL) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File file = new File(fileURL.getPath());
        if (file.isDirectory()) {
            File[] jarFiles = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".jar");
                }
            });
            if (jarFiles != null) {
                for (File jarFile : jarFiles) {
                    urls.add(jarFile.toURI().toURL());
                }
            }
            if (!fileURL.toString().endsWith("/")) {
                fileURL = new URL(fileURL.toString() + "/");
            }
        }
        urls.add(fileURL);
        return urls;
    }
}

