/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.entity.common.FeedDataPath;
import org.apache.falcon.util.RadixNode;

public class FalconRadixUtils {

    public static class FeedRegexAlgorithm
    implements INodeAlgorithm {
        @Override
        public boolean match(String templateString, String inputString) {
            if (StringUtils.isBlank(templateString)) {
                return false;
            }
            List<String> templateParts = this.getPartsInPathTemplate(templateString);
            List<String> inputStringParts = this.getCorrespondingParts(inputString, templateParts);
            if (inputStringParts.size() != templateParts.size()) {
                return false;
            }
            for (int counter = 0; counter < inputStringParts.size(); ++counter) {
                if (this.matchPart(templateParts.get(counter), inputStringParts.get(counter))) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean startsWith(String inputTemplate, String inputString) {
            if (StringUtils.isBlank(inputString)) {
                return false;
            }
            if (StringUtils.isBlank(inputTemplate)) {
                return true;
            }
            List<String> templateParts = this.getPartsInPathTemplate(inputTemplate);
            List<String> remainingPattern = this.getCorrespondingParts(inputString, templateParts);
            if (templateParts.size() > remainingPattern.size()) {
                return false;
            }
            int counter = 0;
            for (String templatePart : templateParts) {
                String part;
                if (!this.matchPart(templatePart, part = remainingPattern.get(counter))) {
                    return false;
                }
                ++counter;
            }
            return true;
        }

        @Override
        public RadixNode getNextCandidate(RadixNode currentNode, String input) {
            RadixNode newRoot = null;
            String remainingText = input.substring(this.getPatternsEffectiveLength(currentNode.getKey()));
            List result = currentNode.getChildren();
            for (RadixNode child : result) {
                String key = child.getKey();
                if (key.startsWith("${")) {
                    FeedDataPath.VARS var;
                    String regex = key.substring(0, key.indexOf("}") + 1);
                    if (!this.matchPart(regex, remainingText.substring(0, (var = this.getMatchingRegex(regex)).getValueSize()))) continue;
                    newRoot = child;
                    break;
                }
                if (child.getKey().charAt(0) != remainingText.charAt(0)) continue;
                newRoot = child;
                break;
            }
            return newRoot;
        }

        @Override
        public String getRemainingText(RadixNode currentNode, String inputString) {
            return inputString.substring(this.getPatternsEffectiveLength(currentNode.getKey()));
        }

        private int getPatternsEffectiveLength(String templateString) {
            if (StringUtils.isBlank(templateString)) {
                return 0;
            }
            for (FeedDataPath.VARS var : FeedDataPath.VARS.values()) {
                templateString = templateString.replace("${" + var.name() + "}", RandomStringUtils.random((int)var.getValueSize()));
            }
            return templateString.length();
        }

        private List<String> getPartsInPathTemplate(String templateString) {
            ArrayList<String> parts = new ArrayList<String>();
            Matcher matcher = FeedDataPath.PATTERN.matcher(templateString);
            int currentIndex = 0;
            while (matcher.find()) {
                parts.add(templateString.substring(currentIndex, matcher.start()));
                parts.add(matcher.group());
                currentIndex = matcher.end();
            }
            if (currentIndex != templateString.length()) {
                parts.add(templateString.substring(currentIndex));
            }
            return Collections.unmodifiableList(parts);
        }

        private FeedDataPath.VARS getMatchingRegex(String inputPart) {
            for (FeedDataPath.VARS var : FeedDataPath.VARS.values()) {
                if (!inputPart.equals("${" + var.name() + "}")) continue;
                return var;
            }
            return null;
        }

        private List<String> getCorrespondingParts(String inputString, List<String> templateParts) {
            ArrayList<String> stringParts = new ArrayList<String>();
            for (int counter = 0; StringUtils.isNotBlank(inputString) && counter < templateParts.size(); ++counter) {
                String currentTemplatePart = templateParts.get(counter);
                int length = Math.min(this.getPatternsEffectiveLength(currentTemplatePart), inputString.length());
                stringParts.add(inputString.substring(0, length));
                inputString = inputString.substring(length);
            }
            if (StringUtils.isNotBlank(inputString)) {
                stringParts.add(inputString);
            }
            return stringParts;
        }

        private boolean matchPart(String template, String input) {
            if (template.startsWith("${")) {
                template = template.replace("${", "\\$\\{");
                template = template.replace("}", "\\}");
                for (FeedDataPath.VARS var : FeedDataPath.VARS.values()) {
                    if (!StringUtils.equals(var.regex(), template)) continue;
                    String desiredPart = input.substring(0, var.getValueSize());
                    Pattern pattern = Pattern.compile(var.getValuePattern());
                    Matcher matcher = pattern.matcher(desiredPart);
                    return matcher.matches();
                }
                return false;
            }
            return input.startsWith(template);
        }
    }

    static class StringAlgorithm
    implements INodeAlgorithm {
        StringAlgorithm() {
        }

        @Override
        public boolean match(String key, String input) {
            return StringUtils.equals(key, input);
        }

        @Override
        public boolean startsWith(String nodeKey, String inputKey) {
            return inputKey.startsWith(nodeKey);
        }

        @Override
        public RadixNode getNextCandidate(RadixNode currentNode, String input) {
            RadixNode newRoot = null;
            String remainingText = input.substring(currentNode.getKey().length());
            List result = currentNode.getChildren();
            for (RadixNode child : result) {
                if (child.getKey().charAt(0) != remainingText.charAt(0)) continue;
                newRoot = child;
                break;
            }
            return newRoot;
        }

        @Override
        public String getRemainingText(RadixNode currentNode, String key) {
            return key.substring(currentNode.getKey().length());
        }
    }

    public static interface INodeAlgorithm {
        public boolean match(String var1, String var2);

        public boolean startsWith(String var1, String var2);

        public RadixNode getNextCandidate(RadixNode var1, String var2);

        public String getRemainingText(RadixNode var1, String var2);
    }
}

