/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.expression.ExpressionHelper;
import org.apache.falcon.security.CredentialProviderHelper;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationProperties
extends Properties {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationProperties.class);
    public static final String CREDENTIAL_PROVIDER_PROPERTY = "credential.provider.path";
    public static final String ALIAS_PROPERTY_PREFIX = "credential.provider.alias.for.";
    protected String domain;

    protected abstract String getPropertyFile();

    protected ApplicationProperties() throws FalconException {
        this.init();
    }

    protected void init() throws FalconException {
        this.setDomain(System.getProperty("falcon.domain", System.getenv("FALCON_DOMAIN")));
        this.loadProperties();
    }

    protected void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    protected void loadProperties() throws FalconException {
        String propertyFileName = this.getPropertyFile();
        String confDir = System.getProperty("config.location");
        this.loadProperties(propertyFileName, confDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties(String propertyFileName, String confDir) throws FalconException {
        try {
            InputStream resourceAsStream = this.checkConfigLocation(propertyFileName, confDir);
            if (resourceAsStream == null) {
                resourceAsStream = this.checkClassPath(propertyFileName);
            }
            if (resourceAsStream != null) {
                try {
                    this.doLoadProperties(resourceAsStream);
                    return;
                }
                finally {
                    IOUtils.closeQuietly(resourceAsStream);
                }
            }
            throw new FileNotFoundException("Unable to find: " + propertyFileName);
        }
        catch (IOException e) {
            throw new FalconException("Error loading properties file: " + this.getPropertyFile(), e);
        }
    }

    private InputStream checkConfigLocation(String propertyFileName, String confDir) throws FileNotFoundException {
        InputStream resourceAsStream = null;
        if (confDir != null) {
            File fileToLoad = new File(confDir, propertyFileName);
            resourceAsStream = this.getResourceAsStream(fileToLoad);
        }
        return resourceAsStream;
    }

    protected InputStream getResourceAsStream(File fileToLoad) throws FileNotFoundException {
        FileInputStream resourceAsStream = null;
        if (fileToLoad.exists() && fileToLoad.isFile() && fileToLoad.canRead()) {
            LOG.info("config.location is set, using: {}", (Object)fileToLoad.getAbsolutePath());
            resourceAsStream = new FileInputStream(fileToLoad);
        }
        return resourceAsStream;
    }

    protected InputStream checkClassPath(String propertyFileName) {
        InputStream resourceAsStream = null;
        Class<ApplicationProperties> clazz = ApplicationProperties.class;
        URL resource = clazz.getResource("/" + propertyFileName);
        if (resource != null) {
            LOG.info("Fallback to classpath for: {}", (Object)resource);
            resourceAsStream = clazz.getResourceAsStream("/" + propertyFileName);
        } else {
            resource = clazz.getResource(propertyFileName);
            if (resource != null) {
                LOG.info("Fallback to classpath for: {}", (Object)resource);
                resourceAsStream = clazz.getResourceAsStream(propertyFileName);
            }
        }
        return resourceAsStream;
    }

    private void doLoadProperties(InputStream resourceAsStream) throws IOException, FalconException {
        Properties origProps = new Properties();
        origProps.load(resourceAsStream);
        if (this.domain == null) {
            this.domain = origProps.getProperty("*.domain");
            if (this.domain == null) {
                throw new FalconException("Domain is not set!");
            }
            this.domain = ExpressionHelper.substitute(this.domain);
        }
        LOG.info("Initializing {} properties with domain {}", (Object)this.getClass().getName(), (Object)this.domain);
        Set<String> keys = this.getKeys(origProps.keySet());
        for (String key : keys) {
            String value = origProps.getProperty(this.domain + "." + key, origProps.getProperty("*." + key));
            if (value == null) continue;
            value = ExpressionHelper.substitute(value);
            LOG.debug("{}={}", (Object)key, (Object)value);
            this.put(key, value);
        }
    }

    protected Set<String> getKeys(Set<Object> keySet) {
        HashSet<String> keys = new HashSet<String>();
        for (Object keyObj : keySet) {
            String key = (String)keyObj;
            keys.add(key.substring(key.indexOf(46) + 1));
        }
        return keys;
    }

    public void resolveAlias() throws FalconException {
        try {
            Configuration conf = new Configuration();
            String providerPath = this.getProperty(CREDENTIAL_PROVIDER_PROPERTY);
            if (providerPath != null) {
                conf.set("hadoop.security.credential.provider.path", providerPath);
            }
            Properties aliasProperties = new Properties();
            for (Object keyObj : this.keySet()) {
                String key = (String)keyObj;
                if (!key.startsWith(ALIAS_PROPERTY_PREFIX)) continue;
                String propertyKey = key.substring(ALIAS_PROPERTY_PREFIX.length());
                String propertyValue = CredentialProviderHelper.resolveAlias(conf, this.getProperty(key));
                aliasProperties.setProperty(propertyKey, propertyValue);
            }
            LOG.info("Resolved alias properties: {}", aliasProperties.stringPropertyNames());
            this.putAll((Map<?, ?>)aliasProperties);
        }
        catch (Exception e) {
            LOG.error("Exception while resolving credential alias", (Throwable)e);
            throw new FalconException("Exception while resolving credential alias", e);
        }
    }

    @Override
    public String getProperty(String key) {
        return StringUtils.trim(super.getProperty(key));
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return StringUtils.trim(super.getProperty(key, defaultValue));
    }
}

