/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.EntityNotRegisteredException;
import org.apache.falcon.entity.EntityUtil;
import org.apache.falcon.entity.v0.AccessControlList;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.security.AuthorizationProvider;
import org.apache.falcon.util.StartupProperties;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationProvider
implements AuthorizationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthorizationProvider.class);
    private static final Set<String> RESOURCES = new HashSet<String>(Arrays.asList("admin", "entities", "instance", "metadata", "extension"));
    private static final String LIST_OPERATION = "list";
    protected static final String FALCON_PREFIX = "falcon.security.authorization.";
    private static final String ADMIN_USERS_KEY = "falcon.security.authorization.admin.users";
    private static final String ADMIN_GROUPS_KEY = "falcon.security.authorization.admin.groups";
    protected static final String SUPER_USER = System.getProperty("user.name");
    private static final String SUPER_USER_GROUP_KEY = "falcon.security.authorization.superusergroup";
    private final String superUserGroup = StartupProperties.get().getProperty("falcon.security.authorization.superusergroup");
    private final Set<String> adminUsers = this.getAdminNamesFromConfig("falcon.security.authorization.admin.users");
    private final Set<String> adminGroups = this.getAdminNamesFromConfig("falcon.security.authorization.admin.groups");

    private Set<String> getAdminNamesFromConfig(String key) {
        HashSet<String> adminNames = new HashSet<String>();
        String adminNamesConfig = StartupProperties.get().getProperty(key);
        if (!StringUtils.isEmpty(adminNamesConfig)) {
            adminNames.addAll(Arrays.asList(adminNamesConfig.split(",")));
        }
        return Collections.unmodifiableSet(adminNames);
    }

    @Override
    public boolean isSuperUser(UserGroupInformation authenticatedUGI) {
        return SUPER_USER.equals(authenticatedUGI.getShortUserName()) || !StringUtils.isEmpty(this.superUserGroup) && this.isUserInGroup(this.superUserGroup, authenticatedUGI);
    }

    @Override
    public boolean shouldProxy(UserGroupInformation authenticatedUGI, String aclOwner, String aclGroup) throws IOException {
        Validate.notNull((Object)authenticatedUGI, (String)"User cannot be empty or null");
        Validate.notEmpty((String)aclOwner, (String)"User cannot be empty or null");
        Validate.notEmpty((String)aclGroup, (String)"Group cannot be empty or null");
        return this.isSuperUser(authenticatedUGI) || !this.isUserACLOwner(authenticatedUGI.getShortUserName(), aclOwner) && this.isUserInGroup(aclGroup, authenticatedUGI);
    }

    @Override
    public void authorizeResource(String resource, String action, String entityType, String entityName, UserGroupInformation authenticatedUGI) throws AuthorizationException, EntityNotRegisteredException {
        Validate.notEmpty((String)resource, (String)"Resource cannot be empty or null");
        Validate.isTrue((boolean)RESOURCES.contains(resource), (String)("Illegal resource: " + resource));
        Validate.notEmpty((String)action, (String)"Action cannot be empty or null");
        try {
            if (this.isSuperUser(authenticatedUGI)) {
                return;
            }
            if ("admin".equals(resource)) {
                if (!("version".equals(action) || "clearuser".equals(action) || "getuser".equals(action))) {
                    this.authorizeAdminResource(authenticatedUGI, action);
                }
            } else if ("entities".equals(resource) || "instance".equals(resource)) {
                if ("entities".equals(resource) && LIST_OPERATION.equals(action)) {
                    LOG.info("Skipping authorization for entity list operations");
                } else {
                    this.authorizeEntityResource(authenticatedUGI, entityName, entityType, action);
                }
            } else if ("metadata".equals(resource)) {
                this.authorizeMetadataResource(authenticatedUGI, action);
            }
        }
        catch (IOException e) {
            throw new AuthorizationException((Throwable)e);
        }
    }

    protected Set<String> getGroupNames(UserGroupInformation proxyUgi) {
        return new HashSet<String>(Arrays.asList(proxyUgi.getGroupNames()));
    }

    @Override
    public void authorizeEntity(String entityName, String entityType, AccessControlList acl, String action, UserGroupInformation authenticatedUGI) throws AuthorizationException {
        try {
            LOG.info("Authorizing authenticatedUser={}, action={}, entity={}, type{}", new Object[]{authenticatedUGI.getShortUserName(), action, entityName, entityType});
            if (this.isSuperUser(authenticatedUGI)) {
                return;
            }
            this.checkUser(entityName, acl.getOwner(), acl.getGroup(), action, authenticatedUGI);
        }
        catch (IOException e) {
            throw new AuthorizationException((Throwable)e);
        }
    }

    protected void checkUser(String entityName, String aclOwner, String aclGroup, String action, UserGroupInformation authenticatedUGI) throws AuthorizationException {
        String authenticatedUser = authenticatedUGI.getShortUserName();
        if (this.isUserACLOwner(authenticatedUser, aclOwner) || this.isUserInGroup(aclGroup, authenticatedUGI)) {
            return;
        }
        StringBuilder message = new StringBuilder("Permission denied: authenticatedUser=");
        message.append(authenticatedUser);
        message.append(!authenticatedUser.equals(aclOwner) ? " not entity owner=" + aclOwner : " not in group=" + aclGroup);
        message.append(", entity=").append(entityName).append(", action=").append(action);
        LOG.error(message.toString());
        throw new AuthorizationException(message.toString());
    }

    protected boolean isUserACLOwner(String authenticatedUser, String aclOwner) {
        return authenticatedUser.equals(aclOwner);
    }

    protected boolean isUserInGroup(String group, UserGroupInformation proxyUgi) {
        Set<String> groups = this.getGroupNames(proxyUgi);
        return groups.contains(group);
    }

    protected void authorizeAdminResource(UserGroupInformation authenticatedUGI, String action) throws AuthorizationException {
        String authenticatedUser = authenticatedUGI.getShortUserName();
        LOG.debug("Authorizing user={} for admin, action={}", (Object)authenticatedUser, (Object)action);
        if (this.adminUsers.contains(authenticatedUser) || this.isUserInAdminGroups(authenticatedUGI)) {
            return;
        }
        LOG.error("Permission denied: user {} does not have admin privilege for action={}", (Object)authenticatedUser, (Object)action);
        throw new AuthorizationException("Permission denied: user=" + authenticatedUser + " does not have admin privilege for action=" + action);
    }

    protected boolean isUserInAdminGroups(UserGroupInformation proxyUgi) {
        Set<String> groups = this.getGroupNames(proxyUgi);
        groups.retainAll(this.adminGroups);
        return !groups.isEmpty();
    }

    protected void authorizeEntityResource(UserGroupInformation authenticatedUGI, String entityName, String entityType, String action) throws AuthorizationException, EntityNotRegisteredException {
        Validate.notEmpty((String)entityType, (String)"Entity type cannot be empty or null");
        LOG.debug("Authorizing authenticatedUser={} against entity/instance action={}, entity name={}, entity type={}", new Object[]{authenticatedUGI.getShortUserName(), action, entityName, entityType});
        if (entityName != null) {
            Entity entity = this.getEntity(entityName, entityType);
            this.authorizeEntity(entity.getName(), entity.getEntityType().name(), entity.getACL(), action, authenticatedUGI);
        } else {
            LOG.info("Authorization for action={} will be done in the API", (Object)action);
        }
    }

    private Entity getEntity(String entityName, String entityType) throws EntityNotRegisteredException, AuthorizationException {
        try {
            EntityType type = EntityType.getEnum(entityType);
            return EntityUtil.getEntity(type, entityName);
        }
        catch (FalconException e) {
            if (e instanceof EntityNotRegisteredException) {
                throw (EntityNotRegisteredException)e;
            }
            throw new AuthorizationException((Throwable)e);
        }
    }

    protected void authorizeMetadataResource(UserGroupInformation authenticatedUGI, String action) throws AuthorizationException {
        LOG.debug("User {} authorized for action {} ", (Object)authenticatedUGI.getShortUserName(), (Object)action);
    }
}

