/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.falcon.FalconException;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CredentialProviderHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialProviderHelper.class);
    private static Class<?> clsCredProvider;
    private static Class<?> clsCredProviderFactory;
    private static Method methGetPassword;
    private static Method methCreateCredEntry;
    private static Method methFlush;
    private static Method methGetProviders;
    public static final String CREDENTIAL_PROVIDER_PATH = "hadoop.security.credential.provider.path";

    private CredentialProviderHelper() {
    }

    public static boolean isProviderAvailable() {
        return clsCredProvider != null && clsCredProviderFactory != null && methCreateCredEntry != null && methGetPassword != null && methFlush != null;
    }

    public static String resolveAlias(Configuration conf, String alias) throws FalconException {
        try {
            char[] cred = (char[])methGetPassword.invoke((Object)conf, alias);
            if (cred == null) {
                throw new FalconException("The provided alias cannot be resolved");
            }
            return new String(cred);
        }
        catch (InvocationTargetException ite) {
            throw new FalconException("Error resolving password  from the credential providers ", ite.getTargetException());
        }
        catch (IllegalAccessException iae) {
            throw new FalconException("Error invoking the credential provider method", iae);
        }
    }

    public static void createCredentialEntry(Configuration conf, String alias, String credential) throws FalconException {
        if (!CredentialProviderHelper.isProviderAvailable()) {
            throw new FalconException("CredentialProvider facility not available in the hadoop environment");
        }
        try {
            List result = (List)methGetProviders.invoke(null, conf);
            Object provider = result.get(0);
            LOG.debug("Using credential provider " + provider);
            methCreateCredEntry.invoke(provider, alias, credential.toCharArray());
            methFlush.invoke(provider, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            throw new FalconException("Error creating credential entry using the credential provider", ite.getTargetException());
        }
        catch (IllegalAccessException iae) {
            throw new FalconException("Error accessing the credential create method", iae);
        }
    }

    static {
        try {
            LOG.debug("Reflecting credential provider classes and methods");
            clsCredProvider = Class.forName("org.apache.hadoop.security.alias.CredentialProvider");
            clsCredProviderFactory = Class.forName("org.apache.hadoop.security.alias.CredentialProviderFactory");
            methCreateCredEntry = clsCredProvider.getMethod("createCredentialEntry", String.class, char[].class);
            methFlush = clsCredProvider.getMethod("flush", new Class[0]);
            methGetPassword = Configuration.class.getMethod("getPassword", String.class);
            methGetProviders = clsCredProviderFactory.getMethod("getProviders", Configuration.class);
            LOG.debug("Found CredentialProviderFactory#getProviders");
        }
        catch (ClassNotFoundException | NoSuchMethodException cnfe) {
            LOG.debug("Ignoring exception", (Throwable)cnfe);
        }
    }
}

