/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.retention;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvictedInstanceSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(EvictedInstanceSerDe.class);
    public static final String INSTANCEPATH_PREFIX = "instancePaths=";
    public static final String INSTANCEPATH_SEPARATOR = ",";

    private EvictedInstanceSerDe() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeEvictedInstancePaths(FileSystem fileSystem, Path logFilePath, StringBuffer instances) throws IOException {
        LOG.info("Writing deleted instances {} to path {}", (Object)instances, (Object)logFilePath);
        try (FSDataOutputStream out = null;){
            out = fileSystem.create(logFilePath);
            instances.insert(0, INSTANCEPATH_PREFIX);
            out.write(instances.toString().getBytes());
            FsPermission permission = new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL);
            fileSystem.setPermission(logFilePath, permission);
        }
        if (LOG.isDebugEnabled()) {
            EvictedInstanceSerDe.logEvictedInstancePaths(fileSystem, logFilePath);
        }
    }

    private static void logEvictedInstancePaths(FileSystem fs, Path outPath) throws IOException {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        FSDataInputStream instance = fs.open(outPath);
        IOUtils.copyBytes((InputStream)instance, (OutputStream)writer, (int)4096, (boolean)true);
        LOG.debug("Instance Paths copied to {}", (Object)outPath);
        LOG.debug("Written {}", (Object)writer);
    }

    public static String[] deserializeEvictedInstancePaths(FileSystem fileSystem, Path logFile) throws IOException {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        FSDataInputStream instance = fileSystem.open(logFile);
        IOUtils.copyBytes((InputStream)instance, (OutputStream)writer, (int)4096, (boolean)true);
        String[] instancePaths = writer.toString().split(INSTANCEPATH_PREFIX);
        if (instancePaths.length <= 1) {
            LOG.info("Returning 0 instance paths for feed ");
            return new String[0];
        }
        LOG.info("Returning instance paths for feed {}", (Object)instancePaths[1]);
        return instancePaths[1].split(INSTANCEPATH_SEPARATOR);
    }
}

