/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.resource;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.falcon.resource.EntityList;

@XmlRootElement
@SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class ExtensionJobList {
    @XmlElement
    public int numJobs;
    @XmlElementWrapper(name="jobs")
    public List<JobElement> job;

    public ExtensionJobList() {
        this.numJobs = 0;
        this.job = null;
    }

    public ExtensionJobList(int numJobs) {
        this.numJobs = numJobs;
        this.job = new ArrayList<JobElement>();
    }

    public ExtensionJobList(int numJobs, List<JobElement> elements) {
        this.numJobs = numJobs;
        this.job = elements;
    }

    public void addJob(JobElement element) {
        this.job.add(element);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.numJobs + "\n\n");
        for (JobElement element : this.job) {
            buffer.append(element.toString());
        }
        return buffer.toString();
    }

    public static class JobElement {
        @XmlElement
        public String jobName;
        @XmlElement
        public EntityList jobEntities;

        public JobElement() {
            this.jobName = null;
            this.jobEntities = null;
        }

        public JobElement(String name, EntityList entities) {
            this.jobName = name;
            this.jobEntities = entities;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Job: " + this.jobName + ", #. entities: ");
            buffer.append(this.jobEntities.toString() + "\n");
            return buffer.toString();
        }
    }
}

