/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.metadata;

import com.thinkaurelius.titan.core.BaseVertexQuery;
import com.thinkaurelius.titan.core.Order;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Query;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.metadata.RelationshipProperty;
import org.apache.falcon.metadata.RelationshipType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphUtils {
    private static final Logger LOG = LoggerFactory.getLogger(GraphUtils.class);

    private GraphUtils() {
    }

    public static void dumpToLog(Graph graph) {
        LOG.debug("Vertices of {}", (Object)graph);
        for (Vertex vertex : graph.getVertices()) {
            LOG.debug(GraphUtils.vertexString(vertex));
        }
        LOG.debug("Edges of {}", (Object)graph);
        for (Edge edge : graph.getEdges()) {
            LOG.debug(GraphUtils.edgeString(edge));
        }
    }

    public static void dump(Graph graph) throws IOException {
        GraphUtils.dump(graph, System.out);
    }

    public static void dump(Graph graph, OutputStream outputStream) throws IOException {
        GraphSONWriter.outputGraph((Graph)graph, (OutputStream)outputStream);
    }

    public static void dump(Graph graph, String fileName) throws IOException {
        GraphSONWriter.outputGraph((Graph)graph, (String)fileName);
    }

    public static String vertexString(Vertex vertex) {
        StringBuilder properties = new StringBuilder();
        for (String propertyKey : vertex.getPropertyKeys()) {
            properties.append(propertyKey).append("=").append(vertex.getProperty(propertyKey)).append(", ");
        }
        return "v[" + vertex.getId() + "], Properties[" + properties + "]";
    }

    public static String edgeString(Edge edge) {
        return "e[" + edge.getLabel() + "], [" + edge.getVertex(Direction.OUT).getProperty("name") + " -> " + edge.getLabel() + " -> " + edge.getVertex(Direction.IN).getProperty("name") + "]";
    }

    public static Vertex findVertex(Graph graph, String name, RelationshipType relationshipType) {
        LOG.debug("Finding vertex for: name={}, type={}", (Object)name, (Object)relationshipType.getName());
        GraphQuery query = graph.query().has(RelationshipProperty.NAME.getName(), (Object)name).has(RelationshipProperty.TYPE.getName(), (Object)relationshipType.getName());
        Iterator results = query.vertices().iterator();
        return results.hasNext() ? (Vertex)results.next() : null;
    }

    public static BaseVertexQuery addRangeQuery(BaseVertexQuery query, RelationshipProperty property, String minValue, String maxValue) {
        if (StringUtils.isNotEmpty(minValue)) {
            query.has(property.getName(), (Predicate)Query.Compare.GREATER_THAN_EQUAL, (Object)minValue);
        }
        if (StringUtils.isNotEmpty(maxValue)) {
            query.has(property.getName(), (Predicate)Query.Compare.LESS_THAN_EQUAL, (Object)maxValue);
        }
        return query;
    }

    public static BaseVertexQuery addEqualityQuery(BaseVertexQuery query, RelationshipProperty property, String value) {
        if (StringUtils.isNotEmpty(value)) {
            query.has(property.getName(), (Object)value);
        }
        return query;
    }

    public static BaseVertexQuery addOrderLimitQuery(BaseVertexQuery query, String orderBy, int numResults) {
        if (StringUtils.isNotEmpty(orderBy)) {
            query.orderBy(orderBy, Order.DESC);
        }
        query.limit(numResults);
        return query;
    }
}

