/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.metadata;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONReader;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONWriter;
import java.io.File;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.metadata.MetadataMappingService;

public final class GraphUpdateUtils {
    private static final String BANNER_MSG = "Before running this utility please make sure that Falcon startup properties has the right configuration settings for the graph database, Falcon server is stopped and no other access to the graph database is being performed.";
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private static final String INSTANCE_JSON_FILE = "instanceMetadata.json";

    private GraphUpdateUtils() {
    }

    public static void main(String[] args) {
        block10: {
            String utilsDir;
            File utilsDirFile;
            if (args.length != 2) {
                GraphUpdateUtils.usage();
                System.exit(1);
            }
            System.out.println(BANNER_MSG);
            String operation = args[0].toLowerCase();
            if (!operation.equals(EXPORT) && !operation.equals(IMPORT)) {
                GraphUpdateUtils.usage();
                System.exit(1);
            }
            if (!(utilsDirFile = new File(utilsDir = args[1])).isDirectory()) {
                System.err.println(utilsDir + " is not a valid directory");
                System.exit(1);
            }
            String jsonFile = new File(utilsDirFile, INSTANCE_JSON_FILE).getAbsolutePath();
            try {
                if (operation.equals(EXPORT)) {
                    Graph graph = MetadataMappingService.initializeGraphDB();
                    GraphSONWriter.outputGraph((Graph)graph, (String)jsonFile);
                    System.out.println("Exported instance metadata to " + jsonFile);
                    break block10;
                }
                Configuration graphConfig = MetadataMappingService.getConfiguration();
                String graphStore = (String)graphConfig.getProperty("storage.directory");
                File graphStoreFile = new File(graphStore);
                File graphDirBackup = new File(graphStore + "_backup");
                if (graphDirBackup.exists()) {
                    FileUtils.deleteDirectory(graphDirBackup);
                }
                FileUtils.copyDirectory(graphStoreFile, graphDirBackup);
                FileUtils.deleteDirectory(graphStoreFile);
                Graph graph = MetadataMappingService.initializeGraphDB();
                try {
                    GraphSONReader.inputGraph((Graph)graph, (String)jsonFile);
                    System.out.println("Imported instance metadata to " + jsonFile);
                }
                catch (Exception ex) {
                    String errorMsg = ex.getMessage();
                    if (graphStoreFile.exists()) {
                        FileUtils.deleteDirectory(graphStoreFile);
                    }
                    FileUtils.copyDirectory(graphDirBackup, graphStoreFile);
                    throw new FalconException(errorMsg);
                }
            }
            catch (Exception e) {
                System.err.println("Error " + operation + "ing JSON data to " + jsonFile + ", " + e.getMessage());
                e.printStackTrace(System.out);
                System.exit(1);
            }
        }
        System.exit(0);
    }

    public static void usage() {
        StringBuilder usageMessage = new StringBuilder(1024);
        usageMessage.append("usage: java ").append(GraphUpdateUtils.class.getName()).append(" {").append(EXPORT).append('|').append(IMPORT).append("} <directory>");
        System.err.println(usageMessage);
    }
}

