/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.group;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.FeedHelper;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.Frequency;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.feed.LocationType;
import org.apache.falcon.group.FeedGroup;
import org.apache.falcon.service.ConfigurationChangeListener;

public final class FeedGroupMap
implements ConfigurationChangeListener {
    private static final FeedGroupMap INSTANCE = new FeedGroupMap();
    private Map<String, FeedGroup> groupsMapping = new ConcurrentHashMap<String, FeedGroup>();

    private FeedGroupMap() {
    }

    public static FeedGroupMap get() {
        return INSTANCE;
    }

    public Map<String, FeedGroup> getGroupsMapping() {
        return Collections.unmodifiableMap(this.groupsMapping);
    }

    @Override
    public void onAdd(Entity entity) throws FalconException {
        if (entity.getEntityType().equals((Object)EntityType.FEED)) {
            Feed feed = (Feed)entity;
            if (feed.getGroups() == null || feed.getGroups().equals("")) {
                return;
            }
            Set<FeedGroup> groupSet = this.getGroups(feed);
            this.addGroups(feed.getName(), groupSet);
        }
    }

    @Override
    public void onRemove(Entity entity) throws FalconException {
        if (entity.getEntityType().equals((Object)EntityType.FEED)) {
            String[] groups;
            Feed feed = (Feed)entity;
            if (StringUtils.isEmpty(feed.getGroups())) {
                return;
            }
            for (String group : groups = feed.getGroups().split(",")) {
                this.groupsMapping.get(group).getFeeds().remove(entity.getName());
                if (this.groupsMapping.get(group).getFeeds().size() != 0) continue;
                this.groupsMapping.remove(group);
            }
        }
    }

    @Override
    public void onChange(Entity oldEntity, Entity newEntity) throws FalconException {
        this.onRemove(oldEntity);
        this.onAdd(newEntity);
    }

    @Override
    public void onReload(Entity entity) throws FalconException {
        this.onAdd(entity);
    }

    private void addGroups(String feed, Set<FeedGroup> groups) {
        for (FeedGroup group : groups) {
            if (this.groupsMapping.containsKey(group.getName())) {
                this.groupsMapping.get(group.getName()).getFeeds().add(feed);
                continue;
            }
            group.getFeeds().add(feed);
            this.groupsMapping.put(group.getName(), group);
        }
    }

    public Set<FeedGroup> getGroups(String groups, Frequency frequency, String path) {
        String[] groupArray;
        HashSet<FeedGroup> groupSet = new HashSet<FeedGroup>();
        for (String group : groupArray = groups.split(",")) {
            groupSet.add(new FeedGroup(group, frequency, path));
        }
        return groupSet;
    }

    public Set<FeedGroup> getGroups(Feed feed) throws FalconException {
        return this.getGroups(feed.getGroups(), feed.getFrequency(), FeedHelper.createStorage(feed).getUriTemplate(LocationType.DATA));
    }
}

