/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.parser.ValidationException;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.AccessControlList;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.security.CurrentUser;
import org.apache.falcon.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityParser<T extends Entity> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityParser.class);
    private final EntityType entityType;
    protected final boolean isAuthorizationDisabled;

    protected EntityParser(EntityType entityType) {
        this.entityType = entityType;
        this.isAuthorizationDisabled = !SecurityUtil.isAuthorizationEnabled();
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity parseAndValidate(String xmlString) throws FalconException {
        T t;
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(xmlString.getBytes());
            t = this.parseAndValidate(inputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(inputStream);
        return t;
    }

    public T parse(InputStream xmlStream) throws FalconException {
        try {
            Unmarshaller unmarshaller = this.entityType.getUnmarshaller();
            Entity entity = (Entity)unmarshaller.unmarshal(xmlStream);
            LOG.info("Parsed Entity: {}", (Object)entity.getName());
            return (T)entity;
        }
        catch (Exception e) {
            throw new FalconException(e);
        }
    }

    public T parseAndValidate(InputStream xmlStream) throws FalconException {
        T entity = this.parse(xmlStream);
        this.validate(entity);
        return entity;
    }

    protected void validateEntityExists(EntityType type, String name) throws FalconException {
        if (ConfigurationStore.get().get(type, name) == null) {
            throw new ValidationException("Referenced " + (Object)((Object)type) + " " + name + " is not registered");
        }
    }

    public abstract void validate(T var1) throws FalconException;

    protected void validateACLOwnerAndGroup(AccessControlList acl) throws ValidationException {
        String aclOwner = acl.getOwner();
        String aclGroup = acl.getGroup();
        if (StringUtils.isEmpty(aclOwner)) {
            throw new ValidationException("Entity ACL owner cannot be empty");
        }
        if (StringUtils.isEmpty(aclGroup)) {
            throw new ValidationException("Entity ACL group cannot be empty");
        }
        try {
            UserGroupInformation proxyACLUser = UserGroupInformation.createProxyUser((String)aclOwner, (UserGroupInformation)UserGroupInformation.getLoginUser());
            HashSet<String> groups = new HashSet<String>(Arrays.asList(proxyACLUser.getGroupNames()));
            if (!groups.contains(aclGroup)) {
                throw new AuthorizationException("Invalid group: " + aclGroup + " for user: " + aclOwner);
            }
        }
        catch (IOException e) {
            throw new ValidationException("Invalid acl owner " + aclOwner + ", does not exist or does not belong to group: " + aclGroup);
        }
    }

    protected void authorize(String entityName, AccessControlList acl) throws AuthorizationException {
        try {
            SecurityUtil.getAuthorizationProvider().authorizeEntity(entityName, this.getEntityType().name(), acl, "submit", CurrentUser.getAuthenticatedUGI());
        }
        catch (FalconException e) {
            throw new AuthorizationException((Throwable)e);
        }
        catch (IOException e) {
            throw new AuthorizationException((Throwable)e);
        }
    }
}

