/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.service.ConfigurationChangeListener;

public final class ColoClusterRelation
implements ConfigurationChangeListener {
    private static final ConcurrentHashMap<String, Set<String>> COLO_CLUSTER_MAP = new ConcurrentHashMap();
    private static final ColoClusterRelation INSTANCE = new ColoClusterRelation();

    private ColoClusterRelation() {
    }

    public static ColoClusterRelation get() {
        return INSTANCE;
    }

    public Set<String> getClusters(String colo) {
        if (COLO_CLUSTER_MAP.containsKey(colo)) {
            return COLO_CLUSTER_MAP.get(colo);
        }
        return new HashSet<String>();
    }

    @Override
    public void onAdd(Entity entity) {
        if (entity.getEntityType() != EntityType.CLUSTER) {
            return;
        }
        Cluster cluster = (Cluster)entity;
        COLO_CLUSTER_MAP.putIfAbsent(cluster.getColo(), new HashSet());
        COLO_CLUSTER_MAP.get(cluster.getColo()).add(cluster.getName());
    }

    @Override
    public void onRemove(Entity entity) {
        if (entity.getEntityType() != EntityType.CLUSTER) {
            return;
        }
        Cluster cluster = (Cluster)entity;
        COLO_CLUSTER_MAP.get(cluster.getColo()).remove(cluster.getName());
        if (COLO_CLUSTER_MAP.get(cluster.getColo()).isEmpty()) {
            COLO_CLUSTER_MAP.remove(cluster.getColo());
        }
    }

    @Override
    public void onChange(Entity oldEntity, Entity newEntity) throws FalconException {
        if (oldEntity.getEntityType() != EntityType.CLUSTER) {
            return;
        }
        this.onRemove(oldEntity);
        this.onAdd(newEntity);
    }

    @Override
    public void onReload(Entity entity) throws FalconException {
        this.onAdd(entity);
    }
}

