/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.crypto.Crypto;
import org.apache.commons.crypto.cipher.AbstractCipherTest;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.stream.AbstractCipherStreamTest;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CtrCryptoInputStream;
import org.apache.commons.crypto.stream.CtrCryptoOutputStream;
import org.apache.commons.crypto.stream.input.ChannelInput;
import org.apache.commons.crypto.stream.input.Input;
import org.apache.commons.crypto.stream.input.StreamInput;
import org.apache.commons.crypto.stream.output.ChannelOutput;
import org.apache.commons.crypto.stream.output.Output;
import org.junit.Assert;
import org.junit.Test;

public class CtrCryptoStreamTest
extends AbstractCipherStreamTest {
    @Override
    public void setUp() throws IOException {
        this.transformation = "AES/CTR/NoPadding";
    }

    protected CtrCryptoInputStream newCryptoInputStream(ByteArrayInputStream bais, CryptoCipher cipher, int bufferSize, byte[] iv, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CtrCryptoInputStream(Channels.newChannel(bais), cipher, bufferSize, this.key, iv);
        }
        return new CtrCryptoInputStream((InputStream)bais, cipher, bufferSize, this.key, iv);
    }

    protected CtrCryptoInputStream newCryptoInputStream(String transformation, Properties props, ByteArrayInputStream bais, byte[] key, AlgorithmParameterSpec params, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CtrCryptoInputStream(props, Channels.newChannel(bais), key, ((IvParameterSpec)params).getIV());
        }
        return new CtrCryptoInputStream(props, (InputStream)bais, key, ((IvParameterSpec)params).getIV());
    }

    protected CtrCryptoOutputStream newCryptoOutputStream(ByteArrayOutputStream baos, CryptoCipher cipher, int bufferSize, byte[] iv, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CtrCryptoOutputStream(Channels.newChannel(baos), cipher, bufferSize, this.key, iv);
        }
        return new CtrCryptoOutputStream((OutputStream)baos, cipher, bufferSize, this.key, iv);
    }

    protected CtrCryptoOutputStream newCryptoOutputStream(String transformation, Properties props, ByteArrayOutputStream baos, byte[] key, AlgorithmParameterSpec params, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CtrCryptoOutputStream(props, Channels.newChannel(baos), key, ((IvParameterSpec)params).getIV());
        }
        return new CtrCryptoOutputStream(props, (OutputStream)baos, key, ((IvParameterSpec)params).getIV());
    }

    @Override
    protected void doFieldGetterTest(String cipherClass, ByteArrayOutputStream baos, boolean withChannel) throws Exception {
        if (AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(cipherClass) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        StreamInput streamInput = new StreamInput((InputStream)new ByteArrayInputStream(this.encData), 0);
        try {
            streamInput.seek(0L);
            Assert.fail((String)"Expected UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"Seek is not supported by this implementation");
        }
        try {
            streamInput.read(0L, new byte[0], 0, 0);
            Assert.fail((String)"Expected UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"Positioned read is not supported by this implementation");
        }
        Assert.assertEquals((long)streamInput.available(), (long)this.encData.length);
        ChannelInput channelInput = new ChannelInput(Channels.newChannel(new ByteArrayInputStream(this.encData)));
        try {
            channelInput.seek(0L);
            Assert.fail((String)"Expected UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"Seek is not supported by this implementation");
        }
        try {
            channelInput.read(0L, new byte[0], 0, 0);
            Assert.fail((String)"Expected UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"Positioned read is not supported by this implementation");
        }
        Assert.assertEquals((long)channelInput.available(), (long)0L);
        CtrCryptoInputStream in = new CtrCryptoInputStream((Input)channelInput, this.getCipher(cipherClass), defaultBufferSize, this.key, this.iv);
        Properties props = new Properties();
        String bufferSize = "4096";
        props.put("commons.crypto.stream.buffer.size", "4096");
        in.setStreamOffset((long)smallBufferSize);
        Assert.assertEquals((long)CryptoInputStream.getBufferSize((Properties)props), (long)Integer.parseInt("4096"));
        Assert.assertEquals((long)smallBufferSize, (long)in.getStreamOffset());
        Assert.assertEquals((long)in.getBufferSize(), (long)8192L);
        Assert.assertEquals(in.getCipher().getClass(), Class.forName(cipherClass));
        Assert.assertEquals((Object)in.getKey().getAlgorithm(), (Object)"AES");
        Assert.assertEquals(in.getParams().getClass(), IvParameterSpec.class);
        Assert.assertNotNull((Object)in.getInput());
        in.close();
        CtrCryptoOutputStream out = new CtrCryptoOutputStream((Output)new ChannelOutput(Channels.newChannel(baos)), this.getCipher(cipherClass), Integer.parseInt("4096"), this.key, this.iv);
        out.setStreamOffset((long)smallBufferSize);
        Assert.assertEquals((long)out.getStreamOffset(), (long)smallBufferSize);
        out.close();
    }

    @Test(timeout=120000L)
    public void testDecrypt() throws Exception {
        this.doDecryptTest(AbstractCipherTest.JCE_CIPHER_CLASSNAME, false);
        this.doDecryptTest(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, false);
        this.doDecryptTest(AbstractCipherTest.JCE_CIPHER_CLASSNAME, true);
        this.doDecryptTest(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, true);
    }

    protected void doDecryptTest(String cipherClass, boolean withChannel) throws IOException {
        CtrCryptoInputStream in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        ByteBuffer buf = ByteBuffer.allocateDirect(20000);
        buf.put(this.encData);
        buf.rewind();
        in.decrypt(buf, 0, 20000);
        byte[] readData = new byte[20000];
        byte[] expectedData = new byte[20000];
        buf.get(readData);
        System.arraycopy(this.data, 0, expectedData, 0, 20000);
        Assert.assertArrayEquals((byte[])readData, (byte[])expectedData);
        try {
            in.decryptBuffer(buf);
            Assert.fail((String)"Expected IOException.");
        }
        catch (IOException ex) {
            Assert.assertEquals(ex.getCause().getClass(), ShortBufferException.class);
        }
    }
}

