/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.stream;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import java.util.Random;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.Crypto;
import org.apache.commons.crypto.cipher.AbstractCipherTest;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.CryptoOutputStream;
import org.apache.commons.crypto.utils.ReflectionUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractCipherStreamTest {
    protected final int dataLen = 20000;
    protected final byte[] data = new byte[20000];
    protected byte[] encData;
    private final Properties props = new Properties();
    protected byte[] key = new byte[16];
    protected byte[] iv = new byte[16];
    protected int count = 10000;
    protected static int defaultBufferSize = 8192;
    protected static int smallBufferSize = 1024;
    protected String transformation;

    public abstract void setUp() throws IOException;

    @Before
    public void before() throws Exception {
        SecureRandom random = new SecureRandom();
        ((Random)random).nextBytes(this.data);
        ((Random)random).nextBytes(this.key);
        ((Random)random).nextBytes(this.iv);
        this.setUp();
        this.prepareData();
    }

    @Test(timeout=120000L)
    public void testSkip() throws Exception {
        this.doSkipTest(AbstractCipherTest.JCE_CIPHER_CLASSNAME, false);
        this.doSkipTest(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, false);
        this.doSkipTest(AbstractCipherTest.JCE_CIPHER_CLASSNAME, true);
        this.doSkipTest(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, true);
    }

    @Test(timeout=120000L)
    public void testByteBufferRead() throws Exception {
        this.doByteBufferRead(AbstractCipherTest.JCE_CIPHER_CLASSNAME, false);
        this.doByteBufferRead(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, false);
        this.doByteBufferRead(AbstractCipherTest.JCE_CIPHER_CLASSNAME, true);
        this.doByteBufferRead(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, true);
    }

    @Test(timeout=120000L)
    public void testByteBufferWrite() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.doByteBufferWrite(AbstractCipherTest.JCE_CIPHER_CLASSNAME, baos, false);
        this.doByteBufferWrite(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, baos, false);
        this.doByteBufferWrite(AbstractCipherTest.JCE_CIPHER_CLASSNAME, baos, true);
        this.doByteBufferWrite(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, baos, true);
    }

    @Test(timeout=120000L)
    public void testExceptions() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.doExceptionTest(AbstractCipherTest.JCE_CIPHER_CLASSNAME, baos, false);
        this.doExceptionTest(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, baos, false);
        this.doExceptionTest(AbstractCipherTest.JCE_CIPHER_CLASSNAME, baos, true);
        this.doExceptionTest(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, baos, true);
    }

    @Test(timeout=120000L)
    public void testFieldGetters() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.doFieldGetterTest(AbstractCipherTest.JCE_CIPHER_CLASSNAME, baos, false);
        this.doFieldGetterTest(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, baos, false);
        this.doFieldGetterTest(AbstractCipherTest.JCE_CIPHER_CLASSNAME, baos, true);
        this.doFieldGetterTest(AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, baos, true);
    }

    protected void doSkipTest(String cipherClass, boolean withChannel) throws IOException {
        if (AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(cipherClass) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        try (CryptoInputStream in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);){
            byte[] result = new byte[20000];
            int n1 = this.readAll((InputStream)in, result, 0, 4000);
            Assert.assertEquals((long)in.skip(0L), (long)0L);
            long skipped = in.skip(4000L);
            int n2 = this.readAll((InputStream)in, result, 0, 20000);
            Assert.assertEquals((long)20000L, (long)((long)n1 + skipped + (long)n2));
            byte[] readData = new byte[n2];
            System.arraycopy(result, 0, readData, 0, n2);
            byte[] expectedData = new byte[n2];
            System.arraycopy(this.data, 20000 - n2, expectedData, 0, n2);
            Assert.assertArrayEquals((byte[])readData, (byte[])expectedData);
            try {
                skipped = in.skip(-3L);
                Assert.fail((String)"Skip Negative length should fail.");
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Negative skip length"));
            }
            skipped = in.skip(3L);
            Assert.assertEquals((long)skipped, (long)0L);
        }
    }

    protected void doByteBufferRead(String cipherClass, boolean withChannel) throws Exception {
        if (AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(cipherClass) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        ByteBuffer buf = ByteBuffer.allocate(20100);
        try (CryptoInputStream in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);){
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
        in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 11);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), smallBufferSize, this.iv, withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), smallBufferSize, this.iv, withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 11);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        var5_5 = null;
        try {
            buf = ByteBuffer.allocateDirect(20100);
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 11);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), smallBufferSize, this.iv, withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), smallBufferSize, this.iv, withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 11);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), smallBufferSize, this.iv, withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferFinalReadCheck((InputStream)in, buf, 0);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        var5_5 = null;
        try {
            buf = ByteBuffer.allocate(100);
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        var5_5 = null;
        try {
            buf = ByteBuffer.allocate(20100);
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 11);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 11);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        var5_5 = null;
        try {
            buf = ByteBuffer.allocateDirect(20100);
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 11);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferReadCheck((InputStream)in, buf, 11);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        var5_5 = null;
        try {
            buf.clear();
            this.byteBufferFinalReadCheck((InputStream)in, buf, 0);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
        in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        var5_5 = null;
        try {
            buf = ByteBuffer.allocate(100);
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
    }

    protected void doByteBufferWrite(String cipherClass, ByteArrayOutputStream baos, boolean withChannel) throws Exception {
        if (AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(cipherClass) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        baos.reset();
        CryptoOutputStream out = this.newCryptoOutputStream(baos, this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        this.doByteBufferWrite(out, withChannel);
        baos.reset();
        CryptoCipher cipher = this.getCipher(cipherClass);
        String transformation = cipher.getAlgorithm();
        out = this.newCryptoOutputStream(transformation, this.props, baos, this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        this.doByteBufferWrite(out, withChannel);
        out.write(1);
        Assert.assertTrue((boolean)out.isOpen());
        out = this.newCryptoOutputStream(transformation, this.props, baos, this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
        out.close();
        Assert.assertTrue((!out.isOpen() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExceptionTest(String cipherClass, ByteArrayOutputStream baos, boolean withChannel) throws IOException {
        if (AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(cipherClass) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        CryptoInputStream in = null;
        CryptoOutputStream out = null;
        try {
            in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new GCMParameterSpec(0, new byte[0]), withChannel);
            Assert.fail((String)"Expected IOException.");
        }
        catch (IOException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"Illegal parameters");
        }
        try {
            out = this.newCryptoOutputStream(this.transformation, this.props, baos, new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new GCMParameterSpec(0, new byte[0]), withChannel);
            Assert.fail((String)"Expected IOException.");
        }
        catch (IOException ex) {
            Assert.assertEquals((Object)ex.getMessage(), (Object)"Illegal parameters");
        }
        try {
            in = this.newCryptoInputStream(this.transformation, this.props, new ByteArrayInputStream(this.encData), new SecretKeySpec(new byte[10], "AES"), (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
            Assert.fail((String)"Expected IOException for Invalid Key");
        }
        catch (IOException ex) {
            Assert.assertNotNull((Object)ex);
        }
        try {
            out = this.newCryptoOutputStream(this.transformation, this.props, baos, new byte[10], (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
            Assert.fail((String)"Expected IOException for Invalid Key");
        }
        catch (IOException ex) {
            Assert.assertNotNull((Object)ex);
        }
        try {
            in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
            in.close();
            in.read();
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)ex.getMessage().equals("Stream closed"));
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            Assert.fail((String)"Should not throw exception closing a closed stream.");
        }
        try {
            out = this.newCryptoOutputStream(this.transformation, this.props, baos, this.key, (AlgorithmParameterSpec)new IvParameterSpec(this.iv), withChannel);
            out.close();
            out.checkStream();
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)ex.getMessage().equals("Stream closed"));
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            Assert.fail((String)"Should not throw exception closing a closed stream.");
        }
        try {
            CryptoInputStream.checkStreamCipher((CryptoCipher)this.getCipher(cipherClass));
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)ex.getMessage().equals("AES/CTR/NoPadding is required"));
        }
        finally {
            in.close();
        }
        try {
            in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), this.getCipher(cipherClass), defaultBufferSize, this.iv, false);
            in.mark(0);
            Assert.assertEquals((Object)false, (Object)in.markSupported());
            in.reset();
            Assert.fail((String)"Expected IOException.");
        }
        catch (IOException ex) {
            Assert.assertTrue((boolean)ex.getMessage().equals("mark/reset not supported"));
        }
        finally {
            in.close();
        }
    }

    protected void doFieldGetterTest(String cipherClass, ByteArrayOutputStream baos, boolean withChannel) throws Exception {
        if (AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(cipherClass) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        CryptoCipher cipher = this.getCipher(cipherClass);
        CryptoInputStream in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), cipher, defaultBufferSize, this.iv, withChannel);
        Properties props = new Properties();
        String bufferSize = Integer.toString(defaultBufferSize / 2);
        props.put("commons.crypto.stream.buffer.size", bufferSize);
        Assert.assertEquals((long)CryptoInputStream.getBufferSize((Properties)props), (long)Integer.parseInt(bufferSize));
        Assert.assertEquals((long)in.getBufferSize(), (long)defaultBufferSize);
        Assert.assertEquals(in.getCipher().getClass(), Class.forName(cipherClass));
        Assert.assertEquals((Object)in.getKey().getAlgorithm(), (Object)"AES");
        Assert.assertEquals(in.getParams().getClass(), IvParameterSpec.class);
        Assert.assertNotNull((Object)in.getInput());
        CryptoOutputStream out = this.newCryptoOutputStream(baos, this.getCipher(cipherClass), defaultBufferSize, this.iv, withChannel);
        Assert.assertEquals((long)out.getOutBuffer().capacity(), (long)(defaultBufferSize + cipher.getBlockSize()));
        Assert.assertEquals((long)out.getInBuffer().capacity(), (long)defaultBufferSize);
        Assert.assertEquals((long)out.getBufferSize(), (long)defaultBufferSize);
    }

    private void byteBufferReadCheck(InputStream in, ByteBuffer buf, int bufPos) throws Exception {
        buf.position(bufPos);
        int n = ((ReadableByteChannel)((Object)in)).read(buf);
        Assert.assertEquals((long)(bufPos + n), (long)buf.position());
        byte[] readData = new byte[n];
        buf.rewind();
        buf.position(bufPos);
        buf.get(readData);
        byte[] expectedData = new byte[n];
        System.arraycopy(this.data, 0, expectedData, 0, n);
        Assert.assertArrayEquals((byte[])readData, (byte[])expectedData);
        try {
            in.read(readData, -1, 0);
            Assert.fail((String)"Expected IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertNotNull((Object)ex);
        }
    }

    private void byteBufferFinalReadCheck(InputStream in, ByteBuffer buf, int bufPos) throws Exception {
        buf.position(bufPos);
        int len = 0;
        int n = 0;
        do {
            n = ((ReadableByteChannel)((Object)in)).read(buf);
            len += n;
        } while (n > 0);
        buf.rewind();
        byte[] readData = new byte[len + 1];
        buf.get(readData);
        byte[] expectedData = new byte[len + 1];
        System.arraycopy(this.data, 0, expectedData, 0, len + 1);
        Assert.assertArrayEquals((byte[])readData, (byte[])expectedData);
    }

    private void prepareData() throws IOException {
        CryptoCipher cipher = null;
        try {
            cipher = (CryptoCipher)ReflectionUtils.newInstance((Class)ReflectionUtils.getClassByName((String)AbstractCipherTest.JCE_CIPHER_CLASSNAME), (Object[])new Object[]{this.props, this.transformation});
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal crypto cipher!");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (CryptoOutputStream out = new CryptoOutputStream((OutputStream)baos, cipher, defaultBufferSize, (Key)new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(this.iv));){
            out.write(this.data);
            out.flush();
        }
        this.encData = baos.toByteArray();
    }

    private void doByteBufferWrite(CryptoOutputStream out, boolean withChannel) throws Exception {
        ByteBuffer buf = ByteBuffer.allocateDirect(10000);
        buf.put(this.data, 0, 10000);
        buf.flip();
        int n1 = out.write(buf);
        buf.clear();
        buf.put(this.data, n1, 6666);
        buf.flip();
        int n2 = out.write(buf);
        buf.clear();
        buf.put(this.data, n1 + n2, 20000 - n1 - n2 - 1);
        buf.flip();
        int n3 = out.write(buf);
        out.write(1);
        Assert.assertEquals((long)20000L, (long)(n1 + n2 + n3 + 1));
        try {
            out.write(this.data, 0, this.data.length + 1);
            Assert.fail((String)"Expected IndexOutOfBoundsException.");
        }
        catch (IndexOutOfBoundsException ex) {
            Assert.assertNotNull((Object)ex);
        }
        out.flush();
        try (CryptoInputStream in = this.newCryptoInputStream(new ByteArrayInputStream(this.encData), out.getCipher(), defaultBufferSize, this.iv, withChannel);){
            buf = ByteBuffer.allocate(20100);
            this.byteBufferReadCheck((InputStream)in, buf, 0);
        }
    }

    protected CryptoInputStream newCryptoInputStream(ByteArrayInputStream bais, CryptoCipher cipher, int bufferSize, byte[] iv, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CryptoInputStream(Channels.newChannel(bais), cipher, bufferSize, (Key)new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
        }
        return new CryptoInputStream((InputStream)bais, cipher, bufferSize, (Key)new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
    }

    protected CryptoInputStream newCryptoInputStream(String transformation, Properties props, ByteArrayInputStream bais, byte[] key, AlgorithmParameterSpec params, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CryptoInputStream(transformation, props, Channels.newChannel(bais), (Key)new SecretKeySpec(key, "AES"), params);
        }
        return new CryptoInputStream(transformation, props, (InputStream)bais, (Key)new SecretKeySpec(key, "AES"), params);
    }

    protected CryptoInputStream newCryptoInputStream(String transformation, Properties props, ByteArrayInputStream bais, Key key, AlgorithmParameterSpec params, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CryptoInputStream(transformation, props, Channels.newChannel(bais), key, params);
        }
        return new CryptoInputStream(transformation, props, (InputStream)bais, key, params);
    }

    protected CryptoOutputStream newCryptoOutputStream(ByteArrayOutputStream baos, CryptoCipher cipher, int bufferSize, byte[] iv, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CryptoOutputStream(Channels.newChannel(baos), cipher, bufferSize, (Key)new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
        }
        return new CryptoOutputStream((OutputStream)baos, cipher, bufferSize, (Key)new SecretKeySpec(this.key, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
    }

    protected CryptoOutputStream newCryptoOutputStream(String transformation, Properties props, ByteArrayOutputStream baos, byte[] key, AlgorithmParameterSpec param, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CryptoOutputStream(transformation, props, Channels.newChannel(baos), (Key)new SecretKeySpec(key, "AES"), param);
        }
        return new CryptoOutputStream(transformation, props, (OutputStream)baos, (Key)new SecretKeySpec(key, "AES"), param);
    }

    protected CryptoOutputStream newCryptoOutputStream(String transformation, Properties props, ByteArrayOutputStream baos, Key key, AlgorithmParameterSpec params, boolean withChannel) throws IOException {
        if (withChannel) {
            return new CryptoOutputStream(transformation, props, Channels.newChannel(baos), key, params);
        }
        return new CryptoOutputStream(transformation, props, (OutputStream)baos, key, params);
    }

    private int readAll(InputStream in, byte[] b, int offset, int len) throws IOException {
        int n = 0;
        int total = 0;
        while (n != -1 && (total += n) < len) {
            n = in.read(b, offset + total, len - total);
        }
        return total;
    }

    protected CryptoCipher getCipher(String cipherClass) throws IOException {
        try {
            return (CryptoCipher)ReflectionUtils.newInstance((Class)ReflectionUtils.getClassByName((String)cipherClass), (Object[])new Object[]{this.props, this.transformation});
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal crypto cipher!");
        }
    }

    @Test
    public void testReadWrite() throws Exception {
        this.doReadWriteTest(0, AbstractCipherTest.JCE_CIPHER_CLASSNAME, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(0, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.JCE_CIPHER_CLASSNAME, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.JCE_CIPHER_CLASSNAME, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
        for (int i = 0; i < 8; ++i) {
            this.iv[8 + i] = -1;
        }
        this.doReadWriteTest(this.count, AbstractCipherTest.JCE_CIPHER_CLASSNAME, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.JCE_CIPHER_CLASSNAME, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, this.iv);
        this.doReadWriteTest(this.count, AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME, AbstractCipherTest.JCE_CIPHER_CLASSNAME, this.iv);
    }

    protected void doReadWriteTest(int count, String encCipherClass, String decCipherClass, byte[] iv) throws IOException {
        this.doReadWriteTestForInputStream(count, encCipherClass, decCipherClass, iv);
        this.doReadWriteTestForReadableByteChannel(count, encCipherClass, decCipherClass, iv);
    }

    private void doReadWriteTestForInputStream(int count, String encCipherClass, String decCipherClass, byte[] iv) throws IOException {
        int expected;
        if ((AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(encCipherClass) || AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(decCipherClass)) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        CryptoCipher encCipher = this.getCipher(encCipherClass);
        SecureRandom random = new SecureRandom();
        byte[] originalData = new byte[count];
        byte[] decryptedData = new byte[count];
        random.nextBytes(originalData);
        ByteArrayOutputStream encryptedData = new ByteArrayOutputStream();
        try (CryptoOutputStream out = this.newCryptoOutputStream(encryptedData, encCipher, defaultBufferSize, iv, false);){
            out.write(originalData, 0, originalData.length);
            out.flush();
        }
        CryptoCipher decCipher = this.getCipher(decCipherClass);
        CryptoInputStream in = this.newCryptoInputStream(new ByteArrayInputStream(encryptedData.toByteArray()), decCipher, defaultBufferSize, iv, false);
        int remainingToRead = count;
        int offset = 0;
        while (remainingToRead > 0) {
            int n = in.read(decryptedData, offset, decryptedData.length - offset);
            if (n < 0) continue;
            remainingToRead -= n;
            offset += n;
        }
        Assert.assertArrayEquals((String)"originalData and decryptedData not equal", (byte[])originalData, (byte[])decryptedData);
        in = this.newCryptoInputStream(new ByteArrayInputStream(encryptedData.toByteArray()), decCipher, defaultBufferSize, iv, false);
        DataInputStream originalIn = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(originalData)));
        do {
            expected = originalIn.read();
            Assert.assertEquals((String)"Decrypted stream read by byte does not match", (long)expected, (long)in.read());
        } while (expected != -1);
    }

    private void doReadWriteTestForReadableByteChannel(int count, String encCipherClass, String decCipherClass, byte[] iv) throws IOException {
        int expected;
        if ((AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(encCipherClass) || AbstractCipherTest.OPENSSL_CIPHER_CLASSNAME.equals(decCipherClass)) && !Crypto.isNativeCodeLoaded()) {
            return;
        }
        CryptoCipher encCipher = this.getCipher(encCipherClass);
        SecureRandom random = new SecureRandom();
        byte[] originalData = new byte[count];
        byte[] decryptedData = new byte[count];
        random.nextBytes(originalData);
        ByteArrayOutputStream encryptedData = new ByteArrayOutputStream();
        try (CryptoOutputStream out = this.newCryptoOutputStream(encryptedData, encCipher, defaultBufferSize, iv, true);){
            out.write(originalData, 0, originalData.length);
            out.flush();
        }
        CryptoCipher decCipher = this.getCipher(decCipherClass);
        CryptoInputStream in = this.newCryptoInputStream(new ByteArrayInputStream(encryptedData.toByteArray()), decCipher, defaultBufferSize, iv, true);
        int remainingToRead = count;
        int offset = 0;
        while (remainingToRead > 0) {
            int n = in.read(decryptedData, offset, decryptedData.length - offset);
            if (n < 0) continue;
            remainingToRead -= n;
            offset += n;
        }
        Assert.assertArrayEquals((String)"originalData and decryptedData not equal", (byte[])originalData, (byte[])decryptedData);
        in = this.newCryptoInputStream(new ByteArrayInputStream(encryptedData.toByteArray()), decCipher, defaultBufferSize, iv, true);
        DataInputStream originalIn = new DataInputStream(new BufferedInputStream(new ByteArrayInputStream(originalData)));
        do {
            expected = originalIn.read();
            Assert.assertEquals((String)"Decrypted stream read by byte does not match", (long)expected, (long)in.read());
        } while (expected != -1);
    }
}

